/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CountIfAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CountIfAccumulator.class);
    private long countState = 0L;

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new CountIfAccumulator();
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (arguments[0].isNull(i) || !arguments[0].getBoolean(i)) continue;
                ++this.countState;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (arguments[0].isNull(position) || !arguments[0].getBoolean(position)) continue;
                ++this.countState;
            }
        }
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            this.countState += argument.getLong(i);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void removeInput(Column[] arguments) {
        for (int i = 0; i < arguments[0].getPositionCount(); ++i) {
            if (arguments[0].isNull(i) || !arguments[0].getBoolean(i)) continue;
            --this.countState;
        }
    }

    @Override
    public boolean removable() {
        return true;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException("CountIfAccumulator does not support statistics");
    }

    @Override
    public void reset() {
        this.countState = 0L;
    }
}

