/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.DoubleApproxMostFrequentAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSaving;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.AbstractGroupedApproxMostFrequentAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.SpaceSavingBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.RamUsageEstimator;

public class DoubleGroupedApproxMostFrequentAccumulator
extends AbstractGroupedApproxMostFrequentAccumulator<Double> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DoubleGroupedApproxMostFrequentAccumulator.class);

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + this.state.getEstimatedSize();
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments, AggregationMask mask) {
        int maxBuckets = arguments[1].getInt(0);
        int capacity = arguments[2].getInt(0);
        if (maxBuckets <= 0 || capacity <= 0) {
            throw new SemanticException("The second and third argument must be greater than 0, but got k=" + maxBuckets + ", capacity=" + capacity);
        }
        SpaceSavingBigArray<Double> spaceSavingBigArray = this.getOrCreateSpaceSaving(this.state);
        Column column = arguments[0];
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                int groupId = groupIds[i];
                SpaceSaving<Double> spaceSaving = spaceSavingBigArray.get(groupId, maxBuckets, capacity, DoubleApproxMostFrequentAccumulator::serializeBucket, DoubleApproxMostFrequentAccumulator::deserializeBucket, DoubleApproxMostFrequentAccumulator::calculateKeyByte);
                if (column.isNull(i)) continue;
                spaceSaving.add(column.getDouble(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                int groupId = groupIds[position];
                SpaceSaving<Double> spaceSaving = spaceSavingBigArray.get(groupId, maxBuckets, capacity, DoubleApproxMostFrequentAccumulator::serializeBucket, DoubleApproxMostFrequentAccumulator::deserializeBucket, DoubleApproxMostFrequentAccumulator::calculateKeyByte);
                if (column.isNull(position)) continue;
                spaceSaving.add(column.getDouble(position));
            }
        }
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            SpaceSaving<Double> current = new SpaceSaving<Double>(argument.getBinary(i).getValues(), DoubleApproxMostFrequentAccumulator::serializeBucket, DoubleApproxMostFrequentAccumulator::deserializeBucket, DoubleApproxMostFrequentAccumulator::calculateKeyByte);
            this.state.merge(groupIds[i], current);
        }
    }
}

