/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LinearFillNode
extends FillNode {
    private final Symbol helperColumn;
    @Nullable
    private final List<Symbol> groupingKeys;

    public LinearFillNode(PlanNodeId id, PlanNode child, Symbol helperColumn, List<Symbol> groupingKeys) {
        super(id, child);
        this.helperColumn = helperColumn;
        this.groupingKeys = groupingKeys;
    }

    public Symbol getHelperColumn() {
        return this.helperColumn;
    }

    public Optional<List<Symbol>> getGroupingKeys() {
        return Optional.ofNullable(this.groupingKeys);
    }

    @Override
    public PlanNode clone() {
        return new LinearFillNode(this.id, null, this.helperColumn, this.groupingKeys);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLinearFill(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_LINEAR_FILL_NODE.serialize(byteBuffer);
        Symbol.serialize(this.helperColumn, byteBuffer);
        if (this.groupingKeys == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (ByteBuffer)byteBuffer);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_LINEAR_FILL_NODE.serialize(stream);
        Symbol.serialize(this.helperColumn, stream);
        if (this.groupingKeys == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (OutputStream)stream);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, stream);
            }
        }
    }

    public static LinearFillNode deserialize(ByteBuffer byteBuffer) {
        Symbol helperColumn = Symbol.deserialize(byteBuffer);
        boolean hasValue = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        ArrayList<Symbol> groupingKeys = null;
        if (hasValue) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            groupingKeys = new ArrayList<Symbol>(size);
            while (size-- > 0) {
                groupingKeys.add(Symbol.deserialize(byteBuffer));
            }
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LinearFillNode(planNodeId, null, helperColumn, groupingKeys);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new LinearFillNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.helperColumn, this.groupingKeys);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinearFillNode that = (LinearFillNode)o;
        return Objects.equals(this.helperColumn, that.helperColumn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.helperColumn);
    }

    public String toString() {
        return "LinearFillNode-" + this.getPlanNodeId();
    }
}

