/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class ExistsPredicate
extends Expression {
    private final Expression subquery;

    public ExistsPredicate(Expression subquery) {
        super(null);
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public ExistsPredicate(@Nonnull NodeLocation location, Expression subquery) {
        super(Objects.requireNonNull(location, "location is null"));
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public Expression getSubquery() {
        return this.subquery;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExists(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.subquery);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistsPredicate that = (ExistsPredicate)o;
        return Objects.equals(this.subquery, that.subquery);
    }

    @Override
    public int hashCode() {
        return this.subquery.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return ExistsPredicate.sameClass(this, other);
    }
}

