/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Pair;

public abstract class AbstractCaseWhenThenColumnTransformer
extends ColumnTransformer {
    List<Pair<ColumnTransformer, ColumnTransformer>> whenThenTransformers;
    ColumnTransformer elseTransformer;

    protected AbstractCaseWhenThenColumnTransformer(Type returnType, List<ColumnTransformer> whenTransformers, List<ColumnTransformer> thenTransformers, ColumnTransformer elseTransformer) {
        super(returnType);
        Validate.isTrue((whenTransformers.size() == thenTransformers.size() ? 1 : 0) != 0, (String)"the size between whenTransformers and thenTransformers needs to be same", (Object[])new Object[0]);
        this.whenThenTransformers = new ArrayList<Pair<ColumnTransformer, ColumnTransformer>>();
        for (int i = 0; i < whenTransformers.size(); ++i) {
            this.whenThenTransformers.add((Pair<ColumnTransformer, ColumnTransformer>)new Pair((Object)whenTransformers.get(i), (Object)thenTransformers.get(i)));
        }
        this.elseTransformer = elseTransformer;
    }

    public List<Pair<ColumnTransformer, ColumnTransformer>> getWhenThenColumnTransformers() {
        return this.whenThenTransformers;
    }

    public ColumnTransformer getElseTransformer() {
        return this.elseTransformer;
    }

    @Override
    public void evaluate() {
        ArrayList<Column> thenColumnList = new ArrayList<Column>();
        ColumnTransformer firstWhenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)0).left;
        firstWhenColumnTransformer.evaluate();
        Column firstWhenColumn = firstWhenColumnTransformer.getColumn();
        int positionCount = firstWhenColumn.getPositionCount();
        boolean[] selection = new boolean[positionCount];
        Arrays.fill(selection, true);
        int[] branchIndexForEachRow = new int[positionCount];
        Arrays.fill(branchIndexForEachRow, -1);
        boolean[] selectionForThen = (boolean[])selection.clone();
        for (int i = 0; i < positionCount; ++i) {
            if (branchIndexForEachRow[i] != -1) continue;
            if (!firstWhenColumn.isNull(i) && firstWhenColumn.getBoolean(i)) {
                branchIndexForEachRow[i] = 0;
                selectionForThen[i] = true;
                selection[i] = false;
                continue;
            }
            selectionForThen[i] = false;
        }
        ColumnTransformer firstThenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)0).right;
        firstThenColumnTransformer.evaluateWithSelection(selectionForThen);
        Column firstThenColumn = firstThenColumnTransformer.getColumn();
        thenColumnList.add(firstThenColumn);
        for (int i = 1; i < this.whenThenTransformers.size(); ++i) {
            ColumnTransformer whenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)i).left;
            whenColumnTransformer.evaluateWithSelection(selection);
            Column whenColumn = whenColumnTransformer.getColumn();
            selectionForThen = (boolean[])selection.clone();
            for (int j = 0; j < positionCount; ++j) {
                if (selection[j] && !whenColumn.isNull(j) && whenColumn.getBoolean(j)) {
                    branchIndexForEachRow[j] = i;
                    selectionForThen[j] = true;
                    selection[j] = false;
                    continue;
                }
                selectionForThen[j] = false;
            }
            ColumnTransformer thenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)i).right;
            thenColumnTransformer.evaluateWithSelection(selectionForThen);
            Column thenColumn = thenColumnTransformer.getColumn();
            thenColumnList.add(thenColumn);
        }
        this.doTransform(branchIndexForEachRow, positionCount, thenColumnList);
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        int[] branchIndexForEachRow = new int[selection.length];
        int positionCount = selection.length;
        boolean[] selectionForWhen = (boolean[])selection.clone();
        for (int i = 0; i < selection.length; ++i) {
            branchIndexForEachRow[i] = selection[i] ? -1 : this.whenThenTransformers.size();
        }
        ArrayList<Column> thenColumnList = new ArrayList<Column>();
        for (int i = 0; i < this.whenThenTransformers.size(); ++i) {
            ColumnTransformer whenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)i).left;
            whenColumnTransformer.evaluateWithSelection(selectionForWhen);
            Column whenColumn = whenColumnTransformer.getColumn();
            boolean[] selectionForThen = (boolean[])selectionForWhen.clone();
            for (int j = 0; j < positionCount; ++j) {
                if (selectionForWhen[j] && !whenColumn.isNull(j) && whenColumn.getBoolean(j)) {
                    branchIndexForEachRow[j] = i;
                    selectionForThen[j] = true;
                    selectionForWhen[j] = false;
                    continue;
                }
                selectionForThen[j] = false;
            }
            ColumnTransformer thenColumnTransformer = (ColumnTransformer)this.whenThenTransformers.get((int)i).right;
            thenColumnTransformer.evaluateWithSelection(selectionForThen);
            Column thenColumn = thenColumnTransformer.getColumn();
            thenColumnList.add(thenColumn);
        }
        this.doTransform(branchIndexForEachRow, positionCount, thenColumnList);
    }

    private void doTransform(int[] branchIndexForEachRow, int positionCount, List<Column> thenColumnList) {
        boolean[] selectionForElse = new boolean[positionCount];
        for (int i = 0; i < branchIndexForEachRow.length; ++i) {
            if (branchIndexForEachRow[i] != -1) continue;
            selectionForElse[i] = true;
        }
        this.elseTransformer.evaluateWithSelection(selectionForElse);
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        Column elseColumn = this.elseTransformer.getColumn();
        for (int i = 0; i < positionCount; ++i) {
            Column resultColumn = null;
            Type thenColumnType = null;
            if (branchIndexForEachRow[i] == -1) {
                resultColumn = elseColumn;
                thenColumnType = this.elseTransformer.getType();
            } else if (branchIndexForEachRow[i] < this.whenThenTransformers.size()) {
                resultColumn = thenColumnList.get(branchIndexForEachRow[i]);
                thenColumnType = ((ColumnTransformer)this.whenThenTransformers.get((int)branchIndexForEachRow[i]).right).getType();
            }
            if (resultColumn == null || resultColumn.isNull(i)) {
                builder.appendNull();
                continue;
            }
            this.writeToColumnBuilder(thenColumnType, resultColumn, i, builder);
        }
        this.initializeColumnCache(builder.build());
        for (Pair<ColumnTransformer, ColumnTransformer> whenThenColumnTransformer : this.whenThenTransformers) {
            ((ColumnTransformer)whenThenColumnTransformer.left).clearCache();
            ((ColumnTransformer)whenThenColumnTransformer.right).clearCache();
        }
        this.elseTransformer.clearCache();
    }

    protected abstract void writeToColumnBuilder(Type var1, Column var2, int var3, ColumnBuilder var4);

    @Override
    protected void checkType() {
    }
}

