/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class DoubleNegationColumnTransformer
extends UnaryColumnTransformer {
    public DoubleNegationColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.returnType.writeDouble(columnBuilder, DoubleNegationColumnTransformer.transform(this.childColumnTransformer.getType().getDouble(column, i)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.returnType.writeDouble(columnBuilder, DoubleNegationColumnTransformer.transform(this.childColumnTransformer.getType().getDouble(column, i)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static double transform(double value) {
        return -value;
    }
}

