/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class StrcmpColumnTransformer
extends UnaryColumnTransformer {
    private final Binary binStr;

    public StrcmpColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String str) {
        super(returnType, childColumnTransformer);
        this.binStr = new Binary(str.getBytes());
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                Binary currentValue = column.getBinary(i);
                columnBuilder.writeInt(Integer.compare(currentValue.compareTo(this.binStr), 0));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                Binary currentValue = column.getBinary(i);
                columnBuilder.writeInt(Integer.compare(currentValue.compareTo(this.binStr), 0));
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

