/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyCopySetRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrationPlan;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.mpp.rpc.thrift.TCleanDataNodeCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataNodeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveDataNodeHandler.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;
    private final IRegionGroupAllocator regionGroupAllocator;

    public RemoveDataNodeHandler(ConfigManager configManager) {
        this.configManager = configManager;
        switch (ConfigNodeDescriptor.getInstance().getConf().getRegionGroupAllocatePolicy()) {
            case GREEDY: {
                this.regionGroupAllocator = new GreedyCopySetRegionGroupAllocator();
                break;
            }
            case PGR: {
                this.regionGroupAllocator = new GreedyCopySetRegionGroupAllocator();
                break;
            }
            default: {
                this.regionGroupAllocator = new GreedyCopySetRegionGroupAllocator();
            }
        }
    }

    public boolean checkEnoughDataNodeAfterRemoving(List<TDataNodeLocation> removedDataNodes) {
        int removedDataNodeSize;
        int availableDatanodeSize = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.ReadOnly).size();
        return availableDatanodeSize - (removedDataNodeSize = (int)removedDataNodes.stream().filter(x -> this.configManager.getLoadManager().getNodeStatus(x.getDataNodeId()) != NodeStatus.Unknown).count()) >= NodeInfo.getMinimumDataNode();
    }

    public void changeDataNodeStatus(List<TDataNodeLocation> removedDataNodes, Map<Integer, NodeStatus> nodeStatusMap) {
        LOGGER.info("{}, Begin to change DataNode status, nodeStatusMap: {}", (Object)"[REMOVE_DATANODE_PROCESS]", nodeStatusMap);
        DataNodeAsyncRequestContext changeDataNodeStatusContext = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.SET_SYSTEM_STATUS);
        for (TDataNodeLocation tDataNodeLocation : removedDataNodes) {
            changeDataNodeStatusContext.putRequest(tDataNodeLocation.getDataNodeId(), nodeStatusMap.get(tDataNodeLocation.getDataNodeId()).getStatus());
            changeDataNodeStatusContext.putNodeLocation(tDataNodeLocation.getDataNodeId(), tDataNodeLocation);
        }
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(changeDataNodeStatusContext);
        for (Map.Entry entry : changeDataNodeStatusContext.getResponseMap().entrySet()) {
            int dataNodeId = (Integer)entry.getKey();
            NodeStatus nodeStatus = nodeStatusMap.get(dataNodeId);
            RegionStatus regionStatus = RegionStatus.valueOf((String)nodeStatus.getStatus());
            if (!RegionMigrateService.isSucceed((TSStatus)((TSStatus)entry.getValue()))) {
                LOGGER.error("{}, Failed to change DataNode status, dataNodeId={}, nodeStatus={}", new Object[]{"[REMOVE_DATANODE_PROCESS]", dataNodeId, nodeStatus});
                continue;
            }
            long currentTime = System.nanoTime();
            this.configManager.getLoadManager().forceUpdateNodeCache(NodeType.DataNode, dataNodeId, new NodeHeartbeatSample(currentTime, nodeStatus));
            LOGGER.info("{}, Force update NodeCache: dataNodeId={}, nodeStatus={}, currentTime={}", new Object[]{"[REMOVE_DATANODE_PROCESS]", dataNodeId, nodeStatus, currentTime});
            if (regionStatus == RegionStatus.Removing) continue;
            TreeMap<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>> heartbeatSampleMap = new TreeMap<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>>();
            this.configManager.getPartitionManager().getAllReplicaSets(dataNodeId).forEach(replicaSet -> heartbeatSampleMap.put(replicaSet.getRegionId(), Collections.singletonMap(dataNodeId, new RegionHeartbeatSample(currentTime, regionStatus))));
            this.configManager.getLoadManager().forceUpdateRegionGroupCache(heartbeatSampleMap);
        }
    }

    public List<RegionMigrationPlan> getRegionMigrationPlans(List<TDataNodeLocation> removedDataNodes) {
        ArrayList<RegionMigrationPlan> regionMigrationPlans = new ArrayList<RegionMigrationPlan>();
        for (TDataNodeLocation removedDataNode : removedDataNodes) {
            List<TConsensusGroupId> migratedDataNodeRegions = this.getMigratedDataNodeRegions(removedDataNode);
            regionMigrationPlans.addAll(migratedDataNodeRegions.stream().map(regionId -> RegionMigrationPlan.create(regionId, removedDataNode)).collect(Collectors.toList()));
        }
        return regionMigrationPlans;
    }

    public List<RegionMigrationPlan> selectedRegionMigrationPlans(List<TDataNodeLocation> removedDataNodes) {
        HashSet<Integer> removedDataNodesSet = new HashSet<Integer>();
        for (TDataNodeLocation removedDataNode : removedDataNodes) {
            removedDataNodesSet.add(removedDataNode.dataNodeId);
        }
        List<TDataNodeConfiguration> availableDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Unknown).stream().filter(node -> !removedDataNodesSet.contains(node.getLocation().getDataNodeId())).collect(Collectors.toList());
        ArrayList<RegionMigrationPlan> regionMigrationPlans = new ArrayList<RegionMigrationPlan>();
        regionMigrationPlans.addAll(this.selectMigrationPlans(availableDataNodes, TConsensusGroupType.DataRegion, removedDataNodes));
        regionMigrationPlans.addAll(this.selectMigrationPlans(availableDataNodes, TConsensusGroupType.SchemaRegion, removedDataNodes));
        return regionMigrationPlans;
    }

    public List<RegionMigrationPlan> selectMigrationPlans(List<TDataNodeConfiguration> availableDataNodes, TConsensusGroupType consensusGroupType, List<TDataNodeLocation> removedDataNodes) {
        List<TRegionReplicaSet> allocatedReplicaSets = this.configManager.getPartitionManager().getAllReplicaSets(consensusGroupType);
        HashMap<TConsensusGroupId, TDataNodeLocation> removedNodeMap = new HashMap<TConsensusGroupId, TDataNodeLocation>();
        Set<TRegionReplicaSet> affectedReplicaSets = this.identifyAffectedReplicaSets(allocatedReplicaSets, removedDataNodes, removedNodeMap);
        this.updateReplicaSets(allocatedReplicaSets, affectedReplicaSets, removedNodeMap);
        Map<Integer, TDataNodeConfiguration> availableDataNodeMap = this.buildAvailableDataNodeMap(availableDataNodes);
        Map<Integer, Double> freeDiskSpaceMap = this.buildFreeDiskSpaceMap(availableDataNodes);
        ArrayList<RegionMigrationPlan> migrationPlans = new ArrayList<RegionMigrationPlan>();
        HashMap<TConsensusGroupId, TRegionReplicaSet> remainReplicasMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        HashMap<TConsensusGroupId, String> regionDatabaseMap = new HashMap<TConsensusGroupId, String>();
        HashMap<String, List<TRegionReplicaSet>> databaseAllocatedRegionGroupMap = new HashMap<String, List<TRegionReplicaSet>>();
        for (TRegionReplicaSet replicaSet : affectedReplicaSets) {
            remainReplicasMap.put(replicaSet.getRegionId(), replicaSet);
            String database = this.configManager.getPartitionManager().getRegionDatabase(replicaSet.getRegionId());
            List<TRegionReplicaSet> databaseAllocatedReplicaSets = this.configManager.getPartitionManager().getAllReplicaSets(database, consensusGroupType);
            regionDatabaseMap.put(replicaSet.getRegionId(), database);
            databaseAllocatedRegionGroupMap.put(database, databaseAllocatedReplicaSets);
        }
        Map<TConsensusGroupId, TDataNodeConfiguration> result = this.regionGroupAllocator.removeNodeReplicaSelect(availableDataNodeMap, freeDiskSpaceMap, allocatedReplicaSets, regionDatabaseMap, databaseAllocatedRegionGroupMap, remainReplicasMap);
        for (TConsensusGroupId regionId : result.keySet()) {
            TDataNodeConfiguration selectedNode = result.get(regionId);
            LOGGER.info("Selected DataNode {} for Region {}", (Object)selectedNode.getLocation().getDataNodeId(), (Object)regionId);
            RegionMigrationPlan plan = RegionMigrationPlan.create(regionId, (TDataNodeLocation)removedNodeMap.get(regionId));
            plan.setToDataNode(selectedNode.getLocation());
            migrationPlans.add(plan);
        }
        return migrationPlans;
    }

    private Set<TRegionReplicaSet> identifyAffectedReplicaSets(List<TRegionReplicaSet> allocatedReplicaSets, List<TDataNodeLocation> removedDataNodes, Map<TConsensusGroupId, TDataNodeLocation> removedNodeMap) {
        HashSet<TRegionReplicaSet> affectedReplicaSets = new HashSet<TRegionReplicaSet>();
        ArrayList<TRegionReplicaSet> allocatedCopy = new ArrayList<TRegionReplicaSet>(allocatedReplicaSets);
        for (TDataNodeLocation removedNode : removedDataNodes) {
            allocatedCopy.stream().filter(replicaSet -> replicaSet.getDataNodeLocations().contains(removedNode)).forEach(replicaSet -> {
                removedNodeMap.put(replicaSet.getRegionId(), removedNode);
                affectedReplicaSets.add((TRegionReplicaSet)replicaSet);
            });
        }
        return affectedReplicaSets;
    }

    private void updateReplicaSets(List<TRegionReplicaSet> allocatedReplicaSets, Set<TRegionReplicaSet> affectedReplicaSets, Map<TConsensusGroupId, TDataNodeLocation> removedNodeMap) {
        for (TRegionReplicaSet replicaSet : affectedReplicaSets) {
            allocatedReplicaSets.remove(replicaSet);
            replicaSet.getDataNodeLocations().remove(removedNodeMap.get(replicaSet.getRegionId()));
            allocatedReplicaSets.add(replicaSet);
        }
    }

    private Map<Integer, TDataNodeConfiguration> buildAvailableDataNodeMap(List<TDataNodeConfiguration> availableDataNodes) {
        return availableDataNodes.stream().collect(Collectors.toMap(dataNode -> dataNode.getLocation().getDataNodeId(), Function.identity()));
    }

    private Map<Integer, Double> buildFreeDiskSpaceMap(List<TDataNodeConfiguration> availableDataNodes) {
        HashMap<Integer, Double> freeDiskSpaceMap = new HashMap<Integer, Double>(availableDataNodes.size());
        availableDataNodes.forEach(dataNode -> freeDiskSpaceMap.put(dataNode.getLocation().getDataNodeId(), this.configManager.getLoadManager().getFreeDiskSpace(dataNode.getLocation().getDataNodeId())));
        return freeDiskSpaceMap;
    }

    public void broadcastDataNodeStatusChange(List<TDataNodeLocation> dataNodes) {
        String dataNodesString = dataNodes.stream().map(RegionMaintainHandler::getIdWithRpcEndpoint).collect(Collectors.joining(", "));
        LOGGER.info("{}, BroadcastDataNodeStatusChange start, dataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)dataNodesString);
        List otherOnlineDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().filter(node -> !dataNodes.contains(node.getLocation())).collect(Collectors.toList());
        DataNodeAsyncRequestContext cleanDataNodeCacheContext = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.CLEAN_DATA_NODE_CACHE);
        for (TDataNodeConfiguration tDataNodeConfiguration : otherOnlineDataNodes) {
            TCleanDataNodeCacheReq disableReq = new TCleanDataNodeCacheReq(dataNodes);
            cleanDataNodeCacheContext.putRequest(tDataNodeConfiguration.getLocation().getDataNodeId(), disableReq);
            cleanDataNodeCacheContext.putNodeLocation(tDataNodeConfiguration.getLocation().getDataNodeId(), tDataNodeConfiguration.getLocation());
        }
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(cleanDataNodeCacheContext);
        for (Map.Entry entry : cleanDataNodeCacheContext.getResponseMap().entrySet()) {
            if (RegionMigrateService.isSucceed((TSStatus)((TSStatus)entry.getValue()))) continue;
            LOGGER.error("{}, BroadcastDataNodeStatusChange meets error, status change dataNodes: {}, error datanode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", dataNodesString, entry.getValue()});
            return;
        }
        LOGGER.info("{}, BroadcastDataNodeStatusChange finished, dataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)dataNodesString);
    }

    public void removeDataNodePersistence(List<TDataNodeLocation> removedDataNodes) {
        try {
            this.configManager.getConsensusManager().write(new RemoveDataNodePlan(removedDataNodes));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
        this.configManager.getClusterSchemaManager().adjustMaxRegionGroupNum();
        for (TDataNodeLocation dataNodeLocation : removedDataNodes) {
            PartitionMetrics.unbindDataNodePartitionMetricsWhenUpdate((AbstractMetricService)MetricService.getInstance(), NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint()));
        }
    }

    public void stopDataNodes(List<TDataNodeLocation> removedDataNodes) {
        LOGGER.info("{}, Begin to stop DataNodes and kill the DataNode process: {}", (Object)"[REMOVE_DATANODE_PROCESS]", removedDataNodes);
        DataNodeAsyncRequestContext stopDataNodesContext = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.STOP_AND_CLEAR_DATA_NODE);
        for (TDataNodeLocation tDataNodeLocation : removedDataNodes) {
            stopDataNodesContext.putRequest(tDataNodeLocation.getDataNodeId(), tDataNodeLocation);
            stopDataNodesContext.putNodeLocation(tDataNodeLocation.getDataNodeId(), tDataNodeLocation);
        }
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(stopDataNodesContext);
        for (Map.Entry entry : stopDataNodesContext.getResponseMap().entrySet()) {
            int dataNodeId = (Integer)entry.getKey();
            this.configManager.getLoadManager().removeNodeCache(dataNodeId);
            if (!RegionMigrateService.isSucceed((TSStatus)((TSStatus)entry.getValue()))) {
                LOGGER.error("{}, Stop Data Node meets error, error datanode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", entry.getValue());
                continue;
            }
            LOGGER.info("{}, Stop Data Node {} success.", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)dataNodeId);
        }
    }

    public DataNodeToStatusResp checkRemoveDataNodeRequest(RemoveDataNodePlan removeDataNodePlan) {
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        TSStatus status = this.checkClusterProtocol();
        if (RegionMigrateService.isFailed((TSStatus)status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkRegionReplication(removeDataNodePlan);
        if (RegionMigrateService.isFailed((TSStatus)status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkDataNodeExist(removeDataNodePlan);
        if (RegionMigrateService.isFailed((TSStatus)status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkAllowRemoveDataNodes(removeDataNodePlan);
        if (RegionMigrateService.isFailed((TSStatus)status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        return dataSet;
    }

    private TSStatus checkClusterProtocol() {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (CONF.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus") || CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            status.setCode(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode());
            status.setMessage("SimpleConsensus protocol is not supported to remove data node");
        }
        return status;
    }

    public TSStatus checkRegionReplication(RemoveDataNodePlan removeDataNodePlan) {
        int removedDataNodeSize;
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List<TDataNodeLocation> removedDataNodes = removeDataNodePlan.getDataNodeLocations();
        int availableDatanodeSize = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.ReadOnly).size();
        if (CONF.getSchemaReplicationFactor() == 1 || CONF.getDataReplicationFactor() == 1) {
            for (TDataNodeLocation dataNodeLocation : removedDataNodes) {
                if (!NodeStatus.Running.equals((Object)this.configManager.getLoadManager().getNodeStatus(dataNodeLocation.getDataNodeId()))) {
                    removedDataNodes.remove(dataNodeLocation);
                    LOGGER.error("Failed to remove data node {} because it is not in running and the configuration of cluster is one replication", (Object)dataNodeLocation);
                }
                if (!removedDataNodes.isEmpty()) continue;
                status.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
                status.setMessage("Failed to remove all requested data nodes");
                return status;
            }
        }
        if (availableDatanodeSize - (removedDataNodeSize = (int)removeDataNodePlan.getDataNodeLocations().stream().filter(x -> this.configManager.getLoadManager().getNodeStatus(x.getDataNodeId()) != NodeStatus.Unknown).count()) < NodeInfo.getMinimumDataNode()) {
            status.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
            status.setMessage(String.format("Can't remove datanode due to the limit of replication factor, availableDataNodeSize: %s, maxReplicaFactor: %s, max allowed removed Data Node size is: %s", availableDatanodeSize, NodeInfo.getMinimumDataNode(), availableDatanodeSize - NodeInfo.getMinimumDataNode()));
        }
        return status;
    }

    private TSStatus checkDataNodeExist(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        boolean hasNotExistNode = removeDataNodePlan.getDataNodeLocations().stream().anyMatch(loc -> !allDataNodes.contains(loc));
        if (hasNotExistNode) {
            status.setCode(TSStatusCode.DATANODE_NOT_EXIST.getStatusCode());
            status.setMessage("there exist Data Node in request but not in cluster");
        }
        return status;
    }

    public TSStatus checkAllowRemoveDataNodes(RemoveDataNodePlan removeDataNodePlan) {
        return this.configManager.getProcedureManager().checkRemoveDataNodes(removeDataNodePlan.getDataNodeLocations());
    }

    public Set<TConsensusGroupId> getRemovedDataNodesRegionSet(List<TDataNodeLocation> removedDataNodes) {
        return removedDataNodes.stream().map(this::getMigratedDataNodeRegions).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public List<TConsensusGroupId> getMigratedDataNodeRegions(TDataNodeLocation removedDataNode) {
        return this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(replicaSet -> replicaSet.getDataNodeLocations().contains(removedDataNode)).map(TRegionReplicaSet::getRegionId).collect(Collectors.toList());
    }

    public Set<TDataNodeLocation> getRelatedDataNodeLocations(TDataNodeLocation removedDataNode) {
        return this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(replicaSet -> replicaSet.getDataNodeLocations().contains(removedDataNode)).flatMap(replicaSet -> replicaSet.getDataNodeLocations().stream()).collect(Collectors.toSet());
    }
}

