/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidCommandParser
extends AbstractImapCommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidCommandParser.class);
    private final ImapCommandParserFactory parserFactory;

    public UidCommandParser(ImapCommandParserFactory parserFactory, StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.UID_COMMAND, statusResponseFactory);
        this.parserFactory = parserFactory;
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String commandName = request.atom();
        ImapCommandParser helperCommand = this.parserFactory.getParser(commandName);
        if (!(helperCommand instanceof AbstractUidCommandParser)) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid UID command: '" + commandName + "'");
        }
        LOGGER.debug("Got <command>: UID {}", (Object)commandName);
        AbstractUidCommandParser uidEnabled = (AbstractUidCommandParser)helperCommand;
        return uidEnabled.decode(request, tag, true, session);
    }
}

