/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.queue.activemq;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import javax.jms.ConnectionFactory;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.james.queue.activemq.ActiveMQMailQueueFactory;
import org.apache.james.queue.activemq.EmbeddedActiveMQ;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.ManageableMailQueue;

public class ActiveMQQueueModule
extends AbstractModule {
    protected void configure() {
        this.bind(PersistenceAdapter.class).to(KahaDBPersistenceAdapter.class);
        this.bind(KahaDBPersistenceAdapter.class).in(Scopes.SINGLETON);
        this.bind(EmbeddedActiveMQ.class).in(Scopes.SINGLETON);
        this.bind(ActiveMQMailQueueFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    ConnectionFactory provideEmbededActiveMQ(EmbeddedActiveMQ embeddedActiveMQ) {
        return embeddedActiveMQ.getConnectionFactory();
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends ManageableMailQueue> createActiveMQManageableMailQueueFactory(ActiveMQMailQueueFactory activeMQMailQueueFactory) {
        activeMQMailQueueFactory.setUseJMX(true);
        activeMQMailQueueFactory.init();
        return activeMQMailQueueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<?> provideActiveMQMailQueueFactory(MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory) {
        return mailQueueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends MailQueue> provideMailQueueFactoryGenerics(ActiveMQMailQueueFactory queueFactory) {
        return queueFactory;
    }
}

