/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TransactionSettingsResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String TRANSACTION_SETTINGS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.39";
    private static final byte TYPE_NUM_LOCK_CONFLICTS = -128;
    private static final byte TYPE_BACKEND_LOCK_ACQUIRED = -127;
    private static final long serialVersionUID = 7290122856855738454L;
    private final boolean backendLockAcquired;
    private final int numLockConflicts;

    TransactionSettingsResponseControl() {
        this.backendLockAcquired = false;
        this.numLockConflicts = -1;
    }

    public TransactionSettingsResponseControl(int numLockConflicts, boolean backendLockAcquired) {
        super(TRANSACTION_SETTINGS_RESPONSE_OID, false, TransactionSettingsResponseControl.encodeValue(numLockConflicts, backendLockAcquired));
        this.numLockConflicts = numLockConflicts;
        this.backendLockAcquired = backendLockAcquired;
    }

    public TransactionSettingsResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.numLockConflicts = ASN1Integer.decodeAsInteger(elements[0]).intValue();
            this.backendLockAcquired = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_RESPONSE_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)));
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(int numLockConflicts, boolean backendLockAcquired) {
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Integer(-128, numLockConflicts), new ASN1Boolean(-127, backendLockAcquired));
        return new ASN1OctetString(valueSequence.encode());
    }

    @Override
    @NotNull
    public TransactionSettingsResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new TransactionSettingsResponseControl(oid, isCritical, value);
    }

    public int getNumLockConflicts() {
        return this.numLockConflicts;
    }

    public boolean backendLockAcquired() {
        return this.backendLockAcquired;
    }

    @Nullable
    public static TransactionSettingsResponseControl get(@NotNull ExtendedResult extendedResult) throws LDAPException {
        Control c = extendedResult.getResponseControl(TRANSACTION_SETTINGS_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof TransactionSettingsResponseControl) {
            return (TransactionSettingsResponseControl)c;
        }
        return new TransactionSettingsResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_TXN_SETTINGS_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TransactionSettingsResponseControl(numLockConflicts=");
        buffer.append(this.numLockConflicts);
        buffer.append(", backendLockAcquired=");
        buffer.append(this.backendLockAcquired);
        buffer.append(')');
    }
}

