/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve.delivery;

import com.google.common.base.Strings;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.mailet.Mail;

public class SieveFailureMessageComposer {
    public static MimeMessage composeMessage(Mail aMail, Exception ex, String user) throws MessagingException {
        MimeMessage originalMessage = aMail.getMessage();
        MimeMessage message = new MimeMessage(originalMessage);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart noticePart = new MimeBodyPart();
        noticePart.setText("An error was encountered while processing this mail with the active sieve script for user \"" + user + "\". The error encountered was:\r\n" + ex.getLocalizedMessage() + "\r\n");
        multipart.addBodyPart((BodyPart)noticePart);
        MimeBodyPart originalPart = new MimeBodyPart();
        originalPart.setContent((Object)originalMessage, "message/rfc822");
        if (Strings.isNullOrEmpty((String)originalMessage.getSubject())) {
            originalPart.setFileName(originalMessage.getSubject().trim());
        } else {
            originalPart.setFileName("No Subject");
        }
        originalPart.setDisposition("inline");
        multipart.addBodyPart((BodyPart)originalPart);
        message.setContent((Multipart)multipart);
        message.setSubject("[SIEVE ERROR] " + originalMessage.getSubject());
        message.setHeader("X-Priority", "1");
        message.saveChanges();
        return message;
    }
}

