/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class SuperCallRewriter
implements RuleMethodProcessor {
    SuperCallRewriter() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.containsPotentialSuperCalls();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getFirst();
        while (abstractInsnNode.getOpcode() != 176) {
            if (abstractInsnNode.getOpcode() == 183) {
                this.process(parserClassNode, ruleMethod, (MethodInsnNode)abstractInsnNode);
            }
            abstractInsnNode = abstractInsnNode.getNext();
        }
    }

    private void process(ParserClassNode parserClassNode, RuleMethod ruleMethod, MethodInsnNode methodInsnNode) {
        if ("<init>".equals(methodInsnNode.name)) {
            return;
        }
        String string = this.getSuperMethodName(ruleMethod, methodInsnNode);
        RuleMethod ruleMethod2 = parserClassNode.getRuleMethods().get(string.concat(methodInsnNode.desc));
        if (ruleMethod2 == null) {
            return;
        }
        if (!ruleMethod2.isBodyRewritten()) {
            return;
        }
        ruleMethod2.dontSkipGeneration();
        methodInsnNode.setOpcode(182);
        methodInsnNode.name = string;
        methodInsnNode.owner = parserClassNode.name;
        ruleMethod.setBodyRewritten();
    }

    private String getSuperMethodName(RuleMethod ruleMethod, MethodInsnNode methodInsnNode) {
        Class<?> clazz = ruleMethod.getOwnerClass();
        String string = ruleMethod.name;
        do {
            Preconditions.checkState((clazz = clazz.getSuperclass()) != null);
            string = '$' + string;
        } while (!Type.getInternalName(clazz).equals(methodInsnNode.owner));
        return string;
    }
}

