/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.lambdas.functions;

import com.github.fge.lambdas.Chainer;
import com.github.fge.lambdas.functions.ThrowingFunction;
import java.util.function.Function;

public class FunctionChainer<T, R>
extends Chainer<Function<T, R>, ThrowingFunction<T, R>, FunctionChainer<T, R>>
implements ThrowingFunction<T, R> {
    public FunctionChainer(ThrowingFunction<T, R> function2) {
        super(function2);
    }

    @Override
    public R doApply(T t) throws Throwable {
        return ((ThrowingFunction)this.throwing).doApply(t);
    }

    @Override
    public FunctionChainer<T, R> orTryWith(ThrowingFunction<T, R> other) {
        ThrowingFunction<Object, Object> function2 = t -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return other.doApply(t);
            }
        };
        return new FunctionChainer<Object, Object>(function2);
    }

    @Override
    public <E extends RuntimeException> ThrowingFunction<T, R> orThrow(Class<E> exclass) {
        return t -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw FunctionChainer.rethrow(exclass, throwable);
            }
        };
    }

    @Override
    public Function<T, R> fallbackTo(Function<T, R> fallback) {
        return t -> {
            try {
                return this.doApply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return fallback.apply(t);
            }
        };
    }

    @Override
    public Function<T, R> sneakyThrow() {
        return t -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw FunctionChainer.doSneakyThrow(throwable);
            }
        };
    }

    public Function<T, R> orReturn(R retval) {
        return t -> {
            try {
                return this.doApply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return retval;
            }
        };
    }
}

