/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.exception;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;

public class ForbiddenDelegationException
extends MailboxException {
    private final Username givenUser;
    private final Optional<Username> delegateUser;

    public ForbiddenDelegationException(Username givenUser) {
        super("User " + givenUser.asString() + " delegation request cannot be satisfied");
        this.givenUser = givenUser;
        this.delegateUser = Optional.empty();
    }

    public ForbiddenDelegationException(Username givenUser, Username delegateUser) {
        super("User " + givenUser.asString() + " is not delegated by " + delegateUser.asString());
        this.givenUser = givenUser;
        this.delegateUser = Optional.of(delegateUser);
    }

    public Username givenUser() {
        return this.givenUser;
    }

    public Optional<Username> delegateUser() {
        return this.delegateUser;
    }
}

