/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DataChunker {
    private static final String CHUNK_SIZE_MUST_BE_STRICTLY_POSITIVE = "ChunkSize must be strictly positive";

    public static Flux<ByteBuffer> chunk(byte[] data, int chunkSize) {
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument(chunkSize > 0, CHUNK_SIZE_MUST_BE_STRICTLY_POSITIVE);
        int size = data.length;
        int fullChunkCount = size / chunkSize;
        return Flux.concat(Flux.range(0, fullChunkCount).map(i -> ByteBuffer.wrap(data, i * chunkSize, chunkSize)), DataChunker.lastChunk(data, chunkSize * fullChunkCount, fullChunkCount));
    }

    private static Mono<ByteBuffer> lastChunk(byte[] data, int offset, int index) {
        if (offset == data.length && index > 0) {
            return Mono.empty();
        }
        return Mono.just(ByteBuffer.wrap(data, offset, data.length - offset));
    }
}

