/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.pulsar;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.backends.pulsar.PulsarClients;
import org.apache.james.backends.pulsar.PulsarConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.pulsar.PulsarMailQueue;
import org.apache.james.queue.pulsar.PulsarMailQueueConfiguration;
import org.apache.james.queue.pulsar.PulsarMailQueueConfiguration$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pulsar.client.admin.PulsarAdmin;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\n\u0015\u0001}A\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011%\u0004!\u0011!Q\u0001\n)DQ!\u001c\u0001\u0005\u00029DqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0001\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u001e\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA)\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!! \u0001\t\u0003\ny\bC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\n1\u0002+\u001e7tCJl\u0015-\u001b7Rk\u0016,XMR1di>\u0014\u0018P\u0003\u0002\u0016-\u00051\u0001/\u001e7tCJT!a\u0006\r\u0002\u000bE,X-^3\u000b\u0005eQ\u0012!\u00026b[\u0016\u001c(BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A!\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004PE*,7\r\u001e\t\u0004S1rS\"\u0001\u0016\u000b\u0005-2\u0012aA1qS&\u0011QF\u000b\u0002\u0011\u001b\u0006LG.U;fk\u00164\u0015m\u0019;pef\u0004\"a\f\u0019\u000e\u0003QI!!\r\u000b\u0003\u001fA+Hn]1s\u001b\u0006LG.U;fk\u0016\f1\u0003];mg\u0006\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001\u000e\u001d\u000e\u0003UR!!\u0006\u001c\u000b\u0005]B\u0012\u0001\u00032bG.,g\u000eZ:\n\u0005e*$a\u0005)vYN\f'oQ8oM&<WO]1uS>t\u0017!\u00049vYN\f'o\u00117jK:$8\u000f\u0005\u00025y%\u0011Q(\u000e\u0002\u000e!Vd7/\u0019:DY&,g\u000e^:\u0002\u001b\tdwNY%e\r\u0006\u001cGo\u001c:z!\t\u0001uI\u0004\u0002B\u000b6\t!I\u0003\u0002,\u0007*\u0011A\tG\u0001\u0005E2|'-\u0003\u0002G\u0005\u00061!\t\\8c\u0013\u0012L!\u0001S%\u0003\u000f\u0019\u000b7\r^8ss*\u0011aIQ\u0001\u0011[&lW-T3tg\u0006<Wm\u0015;pe\u0016\u0004B!\u0011'O1&\u0011QJ\u0011\u0002\u0006'R|'/\u001a\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0001\"\u001b8uKJtW\r\u001e\u0006\u0003'R\u000bA!\\1jY*\tQ+A\u0004kC.\f'\u000f^1\n\u0005]\u0003&aC'j[\u0016lUm]:bO\u0016\u0004\"!W.\u000e\u0003iS!aU\"\n\u0005qS&AE'j[\u0016lUm]:bO\u0016\u0004\u0016M\u001d;t\u0013\u0012\fQ$\\1jYF+X-^3Ji\u0016lG)Z2pe\u0006$xN\u001d$bGR|'/\u001f\t\u0003S}K!\u0001\u0019\u0016\u0003;5\u000b\u0017\u000e\\)vKV,\u0017\n^3n\t\u0016\u001cwN]1u_J4\u0015m\u0019;pef\fQ\"\\3ue&\u001cg)Y2u_JL\bCA2h\u001b\u0005!'BA\u0016f\u0015\t1\u0007$A\u0004nKR\u0014\u0018nY:\n\u0005!$'!D'fiJL7MR1di>\u0014\u00180A\u0007hCV<WMU3hSN$(/\u001f\t\u0003G.L!\u0001\u001c3\u0003\u001b\u001d\u000bWoZ3SK\u001eL7\u000f\u001e:z\u0003\u0019a\u0014N\\5u}QAq\u000e]9sgR,h\u000f\u0005\u00020\u0001!)!\u0007\u0003a\u0001g!)!\b\u0003a\u0001w!)a\b\u0003a\u0001\u007f!)!\n\u0003a\u0001\u0017\")Q\f\u0003a\u0001=\")\u0011\r\u0003a\u0001E\")\u0011\u000e\u0003a\u0001U\"\u0012\u0001\u0002\u001f\t\u0003srl\u0011A\u001f\u0006\u0003wR\u000ba!\u001b8kK\u000e$\u0018BA?{\u0005\u0019IeN[3di\u00061\u0011/^3vKN,\"!!\u0001\u0011\r\u0005\r\u0011\u0011CA\u000b\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011AB1u_6L7M\u0003\u0003\u0002\f\u00055\u0011AC2p]\u000e,(O]3oi*\u0019\u0011q\u0002\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\t)AA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u001d\t9\"!\u000b\u000209rA!!\u0007\u0002&A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 y\ta\u0001\u0010:p_Rt$BAA\u0012\u0003\u0015\u00198-\u00197b\u0013\u0011\t9#!\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\u00075\u000b\u0007O\u0003\u0003\u0002(\u0005\u0005\u0002cA\u0015\u00022%\u0019\u00111\u0007\u0016\u0003\u001b5\u000b\u0017\u000e\\)vKV,g*Y7f\u0003\u001d\tX/Z;fg\u0002\nQ!\u00193nS:,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!a\u000e\u0002B)!\u00111IA#\u0003\u0019\u0019G.[3oi*\u0011QCG\u0005\u0005\u0003\u0013\nyDA\u0006Qk2\u001c\u0018M]!e[&t\u0017AB1e[&t\u0007%\u0001\u0004tsN$X-\\\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0003bGR|'OC\u0002\u0002\\i\tQ\u0001]3lW>LA!a\u0018\u0002V\tY\u0011i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\nAa\u001d;paR\u0011\u0011q\r\t\u0005\u0003S\nY'\u0004\u0002\u0002\"%!\u0011QNA\u0011\u0005\u0011)f.\u001b;)\u0007=\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9\bV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003k\u0012!\u0002\u0015:f\t\u0016\u001cHO]8z\u0003!9W\r^)vKV,GCBAA\u0003\u0013\u000bi\tE\u0003\u0002\u0004\u0006\u0015e&\u0004\u0002\u0002\u000e%!\u0011qQA\u0007\u0005!y\u0005\u000f^5p]\u0006d\u0007bBAF!\u0001\u0007\u0011qF\u0001\u0005]\u0006lW\rC\u0004\u0002\u0010B\u0001\r!!%\u0002\u000b\r|WO\u001c;\u0011\t\u0005M\u0015\u0011\u0014\b\u0004S\u0005U\u0015bAALU\u0005\u0001R*Y5m#V,W/\u001a$bGR|'/_\u0005\u0005\u00037\u000biJA\u0007Qe\u00164W\r^2i\u0007>,h\u000e\u001e\u0006\u0004\u0003/S\u0013aC2sK\u0006$X-U;fk\u0016$RALAR\u0003KCq!a#\u0012\u0001\u0004\ty\u0003C\u0004\u0002\u0010F\u0001\r!!%\u0002+1L7\u000f^\"sK\u0006$X\rZ'bS2\fV/Z;fgR\u0011\u00111\u0016\t\u0007\u0003\u0007\u000bi+a\f\n\t\u0005=\u0016Q\u0002\u0002\u0004'\u0016$\b")
public class PulsarMailQueueFactory
implements MailQueueFactory<PulsarMailQueue> {
    private final PulsarConfiguration pulsarConfiguration;
    private final PulsarClients pulsarClients;
    private final BlobId.Factory blobIdFactory;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    private final MetricFactory metricFactory;
    private final GaugeRegistry gaugeRegistry;
    private final AtomicReference<Map<MailQueueName, PulsarMailQueue>> queues;
    private final PulsarAdmin admin;
    private final ActorSystem system;

    public Optional<PulsarMailQueue> getQueue(MailQueueName name) {
        return super.getQueue(name);
    }

    public MailQueue createQueue(MailQueueName name) {
        return super.createQueue(name);
    }

    private AtomicReference<Map<MailQueueName, PulsarMailQueue>> queues() {
        return this.queues;
    }

    private PulsarAdmin admin() {
        return this.admin;
    }

    private ActorSystem system() {
        return this.system;
    }

    @PreDestroy
    public void stop() {
        this.queues().getAndUpdate(map -> {
            map.values().foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return (Map)map.empty();
        });
        this.system().terminate();
    }

    public Optional<PulsarMailQueue> getQueue(MailQueueName name, MailQueueFactory.PrefetchCount count) {
        return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Try$.MODULE$.apply((Function0 & Serializable)() -> this.admin().topics().getInternalInfo("persistent://" + $this.pulsarConfiguration.namespace().asString() + "/James-" + name.asString())).toOption().map((Function1 & Serializable)x$2 -> this.createQueue(name, count))));
    }

    public PulsarMailQueue createQueue(MailQueueName name, MailQueueFactory.PrefetchCount count) {
        return (PulsarMailQueue)((MapOps)this.queues().updateAndGet(map -> {
            PulsarMailQueue queue = (PulsarMailQueue)map.get((Object)name).fold((Function0 & Serializable)() -> new PulsarMailQueue(new PulsarMailQueueConfiguration(name, $this.pulsarConfiguration, PulsarMailQueueConfiguration$.MODULE$.apply$default$3(), PulsarMailQueueConfiguration$.MODULE$.apply$default$4(), PulsarMailQueueConfiguration$.MODULE$.apply$default$5()), $this.pulsarClients, $this.blobIdFactory, $this.mimeMessageStore, $this.mailQueueItemDecoratorFactory, $this.metricFactory, $this.gaugeRegistry, this.system()), (Function1 & Serializable)x -> (PulsarMailQueue)Predef$.MODULE$.identity(x));
            return (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)queue));
        })).apply((Object)name);
    }

    public java.util.Set<MailQueueName> listCreatedMailQueues() {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.admin().topics().getList(this.pulsarConfiguration.namespace().asString())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("persistent://" + this.pulsarConfiguration.namespace().asString() + "/James-")))).map((Function1 & Serializable)x$4 -> x$4.replace("persistent://" + $this.pulsarConfiguration.namespace().asString() + "/James-", ""))).map((Function1 & Serializable)value -> MailQueueName.of((String)value))).toSet()).asJava();
    }

    @Inject
    public PulsarMailQueueFactory(PulsarConfiguration pulsarConfiguration, PulsarClients pulsarClients, BlobId.Factory blobIdFactory, Store<MimeMessage, MimeMessagePartsId> mimeMessageStore, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.pulsarConfiguration = pulsarConfiguration;
        this.pulsarClients = pulsarClients;
        this.blobIdFactory = blobIdFactory;
        this.mimeMessageStore = mimeMessageStore;
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.metricFactory = metricFactory;
        this.gaugeRegistry = gaugeRegistry;
        this.queues = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.admin = pulsarClients.adminClient();
        this.system = ActorSystem$.MODULE$.apply("pulsar-mailqueue");
    }
}

