/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ExpungeResponse;

public class ExpungeResponseEncoder
implements ImapResponseEncoder<ExpungeResponse> {
    public static final byte[] EXPUNGE = "EXPUNGE".getBytes(StandardCharsets.US_ASCII);
    private static final int NO_MESSAGE = -1;

    @Override
    public Class<ExpungeResponse> acceptableMessages() {
        return ExpungeResponse.class;
    }

    @Override
    public void encode(ExpungeResponse expungeResponse, ImapResponseComposer composer) throws IOException {
        int messageSequenceNumber = expungeResponse.getMessageSequenceNumber().asInt().orElse(-1);
        composer.untagged().message(messageSequenceNumber).message(EXPUNGE).end();
    }
}

