/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.exception.MailboxException;

public final class NullableMessageSequenceNumber {
    private final Optional<MessageSequenceNumber> msn;

    public static NullableMessageSequenceNumber noMessage() {
        return new NullableMessageSequenceNumber(Optional.empty());
    }

    public static NullableMessageSequenceNumber of(int msn) {
        return new NullableMessageSequenceNumber(Optional.of(MessageSequenceNumber.of(msn)));
    }

    private NullableMessageSequenceNumber(Optional<MessageSequenceNumber> msn) {
        this.msn = msn;
    }

    public void ifPresent(Consumer<MessageSequenceNumber> consumer) {
        this.msn.ifPresent(consumer);
    }

    public <T> T fold(HandleNoMessage<T> handleNoMessage, HandleMessage<T> handleMessage) throws MailboxException {
        if (this.msn.isPresent()) {
            return handleMessage.handle(this.msn.get());
        }
        return handleNoMessage.handle();
    }

    public <T> T foldSilent(Supplier<T> handleNoMessage, Function<MessageSequenceNumber, T> handleMessage) {
        if (this.msn.isPresent()) {
            return handleMessage.apply(this.msn.get());
        }
        return handleNoMessage.get();
    }

    public Optional<Integer> asInt() {
        return this.msn.map(MessageSequenceNumber::asInt);
    }

    public boolean equals(Object o) {
        if (o instanceof NullableMessageSequenceNumber) {
            NullableMessageSequenceNumber that = (NullableMessageSequenceNumber)o;
            return Objects.equals(this.msn, that.msn);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.msn);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("msn", this.msn).toString();
    }

    public static interface HandleMessage<T> {
        public T handle(MessageSequenceNumber var1) throws MailboxException;
    }

    public static interface HandleNoMessage<T> {
        public T handle() throws MailboxException;
    }
}

