/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.config;

import com.sksamuel.exts.Logging;
import com.sksamuel.exts.OptionImplicits$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;

public final class ConfigResolver$
implements Logging {
    public static final ConfigResolver$ MODULE$ = new ConfigResolver$();
    private static final String EnvConfFilename;
    private static final String OverrideFilename;
    private static final String AppConfFilename;
    private static final Path userHome;
    private static final Path cwd;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        EnvConfFilename = "env_exts.conf";
        OverrideFilename = "override.conf";
        AppConfFilename = "app_exts.conf";
        userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        cwd = Paths.get(".", new String[0]);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String EnvConfFilename() {
        return EnvConfFilename;
    }

    private String OverrideFilename() {
        return OverrideFilename;
    }

    private String AppConfFilename() {
        return AppConfFilename;
    }

    private Path userHome() {
        return userHome;
    }

    private Path cwd() {
        return cwd;
    }

    public Config apply(boolean log) {
        Config refconf = ConfigFactory.defaultReference();
        Config appconf = ConfigFactory.parseResources((String)this.AppConfFilename());
        return this.loadOverrideConf$1(log).withFallback((ConfigMergeable)this.loadEnvConf$1(log)).withFallback((ConfigMergeable)appconf).withFallback((ConfigMergeable)refconf);
    }

    public boolean apply$default$1() {
        return false;
    }

    private final Config loadEnvConf$1(boolean log$1) {
        Path path;
        block0: {
            path = this.userHome().resolve(this.EnvConfFilename()).toAbsolutePath();
            if (!log$1) break block0;
            this.logger().info(new StringBuilder(21).append("Detecting env conf [").append(path).append("]").toString());
        }
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path).option().fold((Function0 & Serializable)() -> ConfigFactory.empty(), (Function1 & Serializable)it -> ConfigFactory.parseFile((File)it.toFile()));
    }

    private final Config loadOverrideConf$1(boolean log$1) {
        Path path;
        block0: {
            path = this.cwd().resolve(this.OverrideFilename()).toAbsolutePath();
            if (!log$1) break block0;
            this.logger().info(new StringBuilder(26).append("Detecting override conf [").append(path).append("]").toString());
        }
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path).option().fold((Function0 & Serializable)() -> ConfigFactory.empty(), (Function1 & Serializable)it -> ConfigFactory.parseFile((File)it.toFile()));
    }

    private ConfigResolver$() {
    }
}

