/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientResponseValue;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String INTERMEDIATE_CLIENT_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.2";
    @NotNull
    private static final String JSON_FIELD_SERVER_NAME = "server-name";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESPONSE_ID = "server-response-id";
    @NotNull
    private static final String JSON_FIELD_SERVER_SESSION_ID = "server-session-id";
    @NotNull
    private static final String JSON_FIELD_UPSTREAM_RESPONSE = "upstream-response";
    @NotNull
    private static final String JSON_FIELD_UPSTREAM_SERVER_ADDRESS = "upstream-server-address";
    @NotNull
    private static final String JSON_FIELD_UPSTREAM_SERVER_SECURE = "upstream-server-secure";
    private static final long serialVersionUID = 7476073413872875835L;
    @NotNull
    private final IntermediateClientResponseValue value;

    IntermediateClientResponseControl() {
        this.value = null;
    }

    public IntermediateClientResponseControl(@Nullable IntermediateClientResponseValue upstreamResponse, @Nullable String upstreamServerAddress, @Nullable Boolean upstreamServerSecure, @Nullable String serverName, @Nullable String serverSessionID, @Nullable String serverResponseID) {
        this(false, new IntermediateClientResponseValue(upstreamResponse, upstreamServerAddress, upstreamServerSecure, serverName, serverSessionID, serverResponseID));
    }

    public IntermediateClientResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CONTROL_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CONTROL_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.value = IntermediateClientResponseValue.decode(valueSequence);
    }

    public IntermediateClientResponseControl(@NotNull IntermediateClientResponseValue value) {
        this(false, value);
    }

    public IntermediateClientResponseControl(boolean isCritical, @NotNull IntermediateClientResponseValue value) {
        super(INTERMEDIATE_CLIENT_RESPONSE_OID, isCritical, new ASN1OctetString(value.encode().encode()));
        this.value = value;
    }

    @Override
    @NotNull
    public IntermediateClientResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new IntermediateClientResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static IntermediateClientResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(INTERMEDIATE_CLIENT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof IntermediateClientResponseControl) {
            return (IntermediateClientResponseControl)c;
        }
        return new IntermediateClientResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public IntermediateClientResponseValue getResponseValue() {
        return this.value;
    }

    @Nullable
    public IntermediateClientResponseValue getUpstreamResponse() {
        return this.value.getUpstreamResponse();
    }

    @Nullable
    public String getUpstreamServerAddress() {
        return this.value.getUpstreamServerAddress();
    }

    @Nullable
    public Boolean upstreamServerSecure() {
        return this.value.upstreamServerSecure();
    }

    @Nullable
    public String getServerName() {
        return this.value.getServerName();
    }

    @Nullable
    public String getServerSessionID() {
        return this.value.getServerSessionID();
    }

    @Nullable
    public String getServerResponseID() {
        return this.value.getServerResponseID();
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", INTERMEDIATE_CLIENT_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", IntermediateClientResponseControl.encodeResponseValueJSON(this.value)));
    }

    @NotNull
    private static JSONObject encodeResponseValueJSON(@NotNull IntermediateClientResponseValue value) {
        String serverResponseID;
        String serverSessionID;
        String serverName;
        Boolean upstreamServerSecure;
        String upstreamServerAddress;
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        IntermediateClientResponseValue upstreamResponse = value.getUpstreamResponse();
        if (upstreamResponse != null) {
            fields.put(JSON_FIELD_UPSTREAM_RESPONSE, IntermediateClientResponseControl.encodeResponseValueJSON(upstreamResponse));
        }
        if ((upstreamServerAddress = value.getUpstreamServerAddress()) != null) {
            fields.put(JSON_FIELD_UPSTREAM_SERVER_ADDRESS, new JSONString(upstreamServerAddress));
        }
        if ((upstreamServerSecure = value.upstreamServerSecure()) != null) {
            fields.put(JSON_FIELD_UPSTREAM_SERVER_SECURE, new JSONBoolean(upstreamServerSecure));
        }
        if ((serverName = value.getServerName()) != null) {
            fields.put(JSON_FIELD_SERVER_NAME, new JSONString(serverName));
        }
        if ((serverSessionID = value.getServerSessionID()) != null) {
            fields.put(JSON_FIELD_SERVER_SESSION_ID, new JSONString(serverSessionID));
        }
        if ((serverResponseID = value.getServerResponseID()) != null) {
            fields.put(JSON_FIELD_SERVER_RESPONSE_ID, new JSONString(serverResponseID));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static IntermediateClientResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new IntermediateClientResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        IntermediateClientResponseValue value = IntermediateClientResponseControl.decodeIntermediateClientResponseValueJSON(controlObject, jsonControl.getValueObject(), false, strict);
        return new IntermediateClientResponseControl(jsonControl.getCriticality(), value);
    }

    @NotNull
    private static IntermediateClientResponseValue decodeIntermediateClientResponseValueJSON(@NotNull JSONObject controlObject, @NotNull JSONObject valueObject, boolean isUpstreamResponse, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONObject upstreamResponseObject = valueObject.getFieldAsObject(JSON_FIELD_UPSTREAM_RESPONSE);
        IntermediateClientResponseValue upstreamResponse = upstreamResponseObject == null ? null : IntermediateClientResponseControl.decodeIntermediateClientResponseValueJSON(controlObject, upstreamResponseObject, true, strict);
        String upstreamServerAddress = valueObject.getFieldAsString(JSON_FIELD_UPSTREAM_SERVER_ADDRESS);
        Boolean upstreamServerSecure = valueObject.getFieldAsBoolean(JSON_FIELD_UPSTREAM_SERVER_SECURE);
        String serverName = valueObject.getFieldAsString(JSON_FIELD_SERVER_NAME);
        String serverSessionID = valueObject.getFieldAsString(JSON_FIELD_SERVER_SESSION_ID);
        String serverResponseID = valueObject.getFieldAsString(JSON_FIELD_SERVER_RESPONSE_ID);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_UPSTREAM_RESPONSE, JSON_FIELD_UPSTREAM_SERVER_ADDRESS, JSON_FIELD_UPSTREAM_SERVER_SECURE, JSON_FIELD_SERVER_NAME, JSON_FIELD_SERVER_SESSION_ID, JSON_FIELD_SERVER_RESPONSE_ID)).isEmpty()) {
            if (isUpstreamResponse) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INTERMEDIATE_CLIENT_RESPONSE_JSON_US_VALUE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INTERMEDIATE_CLIENT_RESPONSE_JSON_VALUE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new IntermediateClientResponseValue(upstreamResponse, upstreamServerAddress, upstreamServerSecure, serverName, serverSessionID, serverResponseID);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IntermediateClientResponseControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", value=");
        this.value.toString(buffer);
        buffer.append(')');
    }
}

