/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.XyShapeFieldQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class XyShapeQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final XyShapeFieldQuery xyShape;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<XyShapeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, XyShapeQuery::setupXyShapeQueryDeserializer);

    private XyShapeQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.xyShape = ApiTypeHelper.requireNonNull(builder.xyShape, this, "xy_shape");
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public static XyShapeQuery of(Function<Builder, ObjectBuilder<XyShapeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.XyShape;
    }

    public final String field() {
        return this.field;
    }

    public final XyShapeFieldQuery xyShape() {
        return this.xyShape;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.xyShape.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).xyShape(this.xyShape);
    }

    protected static void setupXyShapeQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.xyShape(XyShapeFieldQuery._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<XyShapeQuery> {
        private String field;
        private XyShapeFieldQuery xyShape;
        @Nullable
        private Boolean ignoreUnmapped;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder xyShape(XyShapeFieldQuery value) {
            this.xyShape = value;
            return this;
        }

        public final Builder xyShape(Function<XyShapeFieldQuery.Builder, ObjectBuilder<XyShapeFieldQuery>> fn) {
            return this.xyShape(fn.apply(new XyShapeFieldQuery.Builder()).build());
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public XyShapeQuery build() {
            this._checkSingleUse();
            return new XyShapeQuery(this);
        }
    }
}

