/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.shard_stores;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.shard_stores.ShardStoreAllocation;
import org.opensearch.client.opensearch.indices.shard_stores.ShardStoreException;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardStore
implements PlainJsonSerializable {
    private final ShardStoreAllocation allocation;
    private final String allocationId;
    private final Map<String, JsonData> attributes;
    private final String id;
    private final long legacyVersion;
    private final String name;
    private final ShardStoreException storeException;
    private final String transportAddress;
    public static final JsonpDeserializer<ShardStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStore::setupShardStoreDeserializer);

    private ShardStore(Builder builder) {
        this.allocation = ApiTypeHelper.requireNonNull(builder.allocation, this, "allocation");
        this.allocationId = ApiTypeHelper.requireNonNull(builder.allocationId, this, "allocationId");
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.legacyVersion = ApiTypeHelper.requireNonNull(builder.legacyVersion, this, "legacyVersion");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.storeException = ApiTypeHelper.requireNonNull(builder.storeException, this, "storeException");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
    }

    public static ShardStore of(Function<Builder, ObjectBuilder<ShardStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStoreAllocation allocation() {
        return this.allocation;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final Map<String, JsonData> attributes() {
        return this.attributes;
    }

    public final String id() {
        return this.id;
    }

    public final long legacyVersion() {
        return this.legacyVersion;
    }

    public final String name() {
        return this.name;
    }

    public final ShardStoreException storeException() {
        return this.storeException;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation");
        this.allocation.serialize(generator, mapper);
        generator.writeKey("allocation_id");
        generator.write(this.allocationId);
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.attributes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("legacy_version");
        generator.write(this.legacyVersion);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("store_exception");
        this.storeException.serialize(generator, mapper);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    protected static void setupShardStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocation, ShardStoreAllocation._DESERIALIZER, "allocation");
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "attributes");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::legacyVersion, JsonpDeserializer.longDeserializer(), "legacy_version");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::storeException, ShardStoreException._DESERIALIZER, "store_exception");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardStore> {
        private ShardStoreAllocation allocation;
        private String allocationId;
        private Map<String, JsonData> attributes;
        private String id;
        private Long legacyVersion;
        private String name;
        private ShardStoreException storeException;
        private String transportAddress;

        public final Builder allocation(ShardStoreAllocation value) {
            this.allocation = value;
            return this;
        }

        public final Builder allocationId(String value) {
            this.allocationId = value;
            return this;
        }

        public final Builder attributes(Map<String, JsonData> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, JsonData value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder legacyVersion(long value) {
            this.legacyVersion = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder storeException(ShardStoreException value) {
            this.storeException = value;
            return this;
        }

        public final Builder storeException(Function<ShardStoreException.Builder, ObjectBuilder<ShardStoreException>> fn) {
            return this.storeException(fn.apply(new ShardStoreException.Builder()).build());
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        public ShardStore build() {
            this._checkSingleUse();
            return new ShardStore(this);
        }
    }
}

