/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.ModelStats;
import org.opensearch.client.opensearch.ml.PredictRequestStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ModelProfile
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ModelProfile> {
    @Nullable
    private final ModelStats deploy;
    @Nullable
    private final ModelStats execute;
    @Nullable
    private final Long memorySizeEstimationCpu;
    @Nullable
    private final Long memorySizeEstimationGpu;
    @Nullable
    private final String modelState;
    @Nullable
    private final ModelStats predict;
    @Nullable
    private final PredictRequestStats predictRequestStats;
    @Nullable
    private final String predictor;
    @Nullable
    private final ModelStats register;
    @Nonnull
    private final List<List<String>> targetWorkerNodes;
    @Nullable
    private final ModelStats train;
    @Nullable
    private final ModelStats trainPredict;
    @Nullable
    private final ModelStats undeploy;
    @Nonnull
    private final List<List<String>> workerNodes;
    public static final JsonpDeserializer<ModelProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelProfile::setupModelProfileDeserializer);

    private ModelProfile(Builder builder) {
        this.deploy = builder.deploy;
        this.execute = builder.execute;
        this.memorySizeEstimationCpu = builder.memorySizeEstimationCpu;
        this.memorySizeEstimationGpu = builder.memorySizeEstimationGpu;
        this.modelState = builder.modelState;
        this.predict = builder.predict;
        this.predictRequestStats = builder.predictRequestStats;
        this.predictor = builder.predictor;
        this.register = builder.register;
        this.targetWorkerNodes = ApiTypeHelper.unmodifiable(builder.targetWorkerNodes);
        this.train = builder.train;
        this.trainPredict = builder.trainPredict;
        this.undeploy = builder.undeploy;
        this.workerNodes = ApiTypeHelper.unmodifiable(builder.workerNodes);
    }

    public static ModelProfile of(Function<Builder, ObjectBuilder<ModelProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ModelStats deploy() {
        return this.deploy;
    }

    @Nullable
    public final ModelStats execute() {
        return this.execute;
    }

    @Nullable
    public final Long memorySizeEstimationCpu() {
        return this.memorySizeEstimationCpu;
    }

    @Nullable
    public final Long memorySizeEstimationGpu() {
        return this.memorySizeEstimationGpu;
    }

    @Nullable
    public final String modelState() {
        return this.modelState;
    }

    @Nullable
    public final ModelStats predict() {
        return this.predict;
    }

    @Nullable
    public final PredictRequestStats predictRequestStats() {
        return this.predictRequestStats;
    }

    @Nullable
    public final String predictor() {
        return this.predictor;
    }

    @Nullable
    public final ModelStats register() {
        return this.register;
    }

    @Nonnull
    public final List<List<String>> targetWorkerNodes() {
        return this.targetWorkerNodes;
    }

    @Nullable
    public final ModelStats train() {
        return this.train;
    }

    @Nullable
    public final ModelStats trainPredict() {
        return this.trainPredict;
    }

    @Nullable
    public final ModelStats undeploy() {
        return this.undeploy;
    }

    @Nonnull
    public final List<List<String>> workerNodes() {
        return this.workerNodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deploy != null) {
            generator.writeKey("deploy");
            this.deploy.serialize(generator, mapper);
        }
        if (this.execute != null) {
            generator.writeKey("execute");
            this.execute.serialize(generator, mapper);
        }
        if (this.memorySizeEstimationCpu != null) {
            generator.writeKey("memory_size_estimation_cpu");
            generator.write(this.memorySizeEstimationCpu.longValue());
        }
        if (this.memorySizeEstimationGpu != null) {
            generator.writeKey("memory_size_estimation_gpu");
            generator.write(this.memorySizeEstimationGpu.longValue());
        }
        if (this.modelState != null) {
            generator.writeKey("model_state");
            generator.write(this.modelState);
        }
        if (this.predict != null) {
            generator.writeKey("predict");
            this.predict.serialize(generator, mapper);
        }
        if (this.predictRequestStats != null) {
            generator.writeKey("predict_request_stats");
            this.predictRequestStats.serialize(generator, mapper);
        }
        if (this.predictor != null) {
            generator.writeKey("predictor");
            generator.write(this.predictor);
        }
        if (this.register != null) {
            generator.writeKey("register");
            this.register.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.targetWorkerNodes)) {
            generator.writeKey("target_worker_nodes");
            generator.writeStartArray();
            for (List<String> item0 : this.targetWorkerNodes) {
                generator.writeStartArray();
                for (String item1 : item0) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.train != null) {
            generator.writeKey("train");
            this.train.serialize(generator, mapper);
        }
        if (this.trainPredict != null) {
            generator.writeKey("train_predict");
            this.trainPredict.serialize(generator, mapper);
        }
        if (this.undeploy != null) {
            generator.writeKey("undeploy");
            this.undeploy.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.workerNodes)) {
            generator.writeKey("worker_nodes");
            generator.writeStartArray();
            for (List<String> item0 : this.workerNodes) {
                generator.writeStartArray();
                for (String item1 : item0) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupModelProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deploy, ModelStats._DESERIALIZER, "deploy");
        op.add(Builder::execute, ModelStats._DESERIALIZER, "execute");
        op.add(Builder::memorySizeEstimationCpu, JsonpDeserializer.longDeserializer(), "memory_size_estimation_cpu");
        op.add(Builder::memorySizeEstimationGpu, JsonpDeserializer.longDeserializer(), "memory_size_estimation_gpu");
        op.add(Builder::modelState, JsonpDeserializer.stringDeserializer(), "model_state");
        op.add(Builder::predict, ModelStats._DESERIALIZER, "predict");
        op.add(Builder::predictRequestStats, PredictRequestStats._DESERIALIZER, "predict_request_stats");
        op.add(Builder::predictor, JsonpDeserializer.stringDeserializer(), "predictor");
        op.add(Builder::register, ModelStats._DESERIALIZER, "register");
        op.add(Builder::targetWorkerNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "target_worker_nodes");
        op.add(Builder::train, ModelStats._DESERIALIZER, "train");
        op.add(Builder::trainPredict, ModelStats._DESERIALIZER, "train_predict");
        op.add(Builder::undeploy, ModelStats._DESERIALIZER, "undeploy");
        op.add(Builder::workerNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "worker_nodes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.deploy);
        result = 31 * result + Objects.hashCode(this.execute);
        result = 31 * result + Objects.hashCode(this.memorySizeEstimationCpu);
        result = 31 * result + Objects.hashCode(this.memorySizeEstimationGpu);
        result = 31 * result + Objects.hashCode(this.modelState);
        result = 31 * result + Objects.hashCode(this.predict);
        result = 31 * result + Objects.hashCode(this.predictRequestStats);
        result = 31 * result + Objects.hashCode(this.predictor);
        result = 31 * result + Objects.hashCode(this.register);
        result = 31 * result + Objects.hashCode(this.targetWorkerNodes);
        result = 31 * result + Objects.hashCode(this.train);
        result = 31 * result + Objects.hashCode(this.trainPredict);
        result = 31 * result + Objects.hashCode(this.undeploy);
        result = 31 * result + Objects.hashCode(this.workerNodes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProfile other = (ModelProfile)o;
        return Objects.equals(this.deploy, other.deploy) && Objects.equals(this.execute, other.execute) && Objects.equals(this.memorySizeEstimationCpu, other.memorySizeEstimationCpu) && Objects.equals(this.memorySizeEstimationGpu, other.memorySizeEstimationGpu) && Objects.equals(this.modelState, other.modelState) && Objects.equals(this.predict, other.predict) && Objects.equals(this.predictRequestStats, other.predictRequestStats) && Objects.equals(this.predictor, other.predictor) && Objects.equals(this.register, other.register) && Objects.equals(this.targetWorkerNodes, other.targetWorkerNodes) && Objects.equals(this.train, other.train) && Objects.equals(this.trainPredict, other.trainPredict) && Objects.equals(this.undeploy, other.undeploy) && Objects.equals(this.workerNodes, other.workerNodes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ModelProfile> {
        @Nullable
        private ModelStats deploy;
        @Nullable
        private ModelStats execute;
        @Nullable
        private Long memorySizeEstimationCpu;
        @Nullable
        private Long memorySizeEstimationGpu;
        @Nullable
        private String modelState;
        @Nullable
        private ModelStats predict;
        @Nullable
        private PredictRequestStats predictRequestStats;
        @Nullable
        private String predictor;
        @Nullable
        private ModelStats register;
        @Nullable
        private List<List<String>> targetWorkerNodes;
        @Nullable
        private ModelStats train;
        @Nullable
        private ModelStats trainPredict;
        @Nullable
        private ModelStats undeploy;
        @Nullable
        private List<List<String>> workerNodes;

        public Builder() {
        }

        private Builder(ModelProfile o) {
            this.deploy = o.deploy;
            this.execute = o.execute;
            this.memorySizeEstimationCpu = o.memorySizeEstimationCpu;
            this.memorySizeEstimationGpu = o.memorySizeEstimationGpu;
            this.modelState = o.modelState;
            this.predict = o.predict;
            this.predictRequestStats = o.predictRequestStats;
            this.predictor = o.predictor;
            this.register = o.register;
            this.targetWorkerNodes = Builder._listCopy(o.targetWorkerNodes);
            this.train = o.train;
            this.trainPredict = o.trainPredict;
            this.undeploy = o.undeploy;
            this.workerNodes = Builder._listCopy(o.workerNodes);
        }

        private Builder(Builder o) {
            this.deploy = o.deploy;
            this.execute = o.execute;
            this.memorySizeEstimationCpu = o.memorySizeEstimationCpu;
            this.memorySizeEstimationGpu = o.memorySizeEstimationGpu;
            this.modelState = o.modelState;
            this.predict = o.predict;
            this.predictRequestStats = o.predictRequestStats;
            this.predictor = o.predictor;
            this.register = o.register;
            this.targetWorkerNodes = Builder._listCopy(o.targetWorkerNodes);
            this.train = o.train;
            this.trainPredict = o.trainPredict;
            this.undeploy = o.undeploy;
            this.workerNodes = Builder._listCopy(o.workerNodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder deploy(@Nullable ModelStats value) {
            this.deploy = value;
            return this;
        }

        @Nonnull
        public final Builder deploy(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.deploy(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder execute(@Nullable ModelStats value) {
            this.execute = value;
            return this;
        }

        @Nonnull
        public final Builder execute(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.execute(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder memorySizeEstimationCpu(@Nullable Long value) {
            this.memorySizeEstimationCpu = value;
            return this;
        }

        @Nonnull
        public final Builder memorySizeEstimationGpu(@Nullable Long value) {
            this.memorySizeEstimationGpu = value;
            return this;
        }

        @Nonnull
        public final Builder modelState(@Nullable String value) {
            this.modelState = value;
            return this;
        }

        @Nonnull
        public final Builder predict(@Nullable ModelStats value) {
            this.predict = value;
            return this;
        }

        @Nonnull
        public final Builder predict(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.predict(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder predictRequestStats(@Nullable PredictRequestStats value) {
            this.predictRequestStats = value;
            return this;
        }

        @Nonnull
        public final Builder predictRequestStats(Function<PredictRequestStats.Builder, ObjectBuilder<PredictRequestStats>> fn) {
            return this.predictRequestStats(fn.apply(new PredictRequestStats.Builder()).build());
        }

        @Nonnull
        public final Builder predictor(@Nullable String value) {
            this.predictor = value;
            return this;
        }

        @Nonnull
        public final Builder register(@Nullable ModelStats value) {
            this.register = value;
            return this;
        }

        @Nonnull
        public final Builder register(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.register(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder targetWorkerNodes(List<List<String>> list) {
            this.targetWorkerNodes = Builder._listAddAll(this.targetWorkerNodes, list);
            return this;
        }

        @Nonnull
        public final Builder targetWorkerNodes(List<String> value, List<String> ... values) {
            this.targetWorkerNodes = Builder._listAdd(this.targetWorkerNodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder train(@Nullable ModelStats value) {
            this.train = value;
            return this;
        }

        @Nonnull
        public final Builder train(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.train(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder trainPredict(@Nullable ModelStats value) {
            this.trainPredict = value;
            return this;
        }

        @Nonnull
        public final Builder trainPredict(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.trainPredict(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder undeploy(@Nullable ModelStats value) {
            this.undeploy = value;
            return this;
        }

        @Nonnull
        public final Builder undeploy(Function<ModelStats.Builder, ObjectBuilder<ModelStats>> fn) {
            return this.undeploy(fn.apply(new ModelStats.Builder()).build());
        }

        @Nonnull
        public final Builder workerNodes(List<List<String>> list) {
            this.workerNodes = Builder._listAddAll(this.workerNodes, list);
            return this;
        }

        @Nonnull
        public final Builder workerNodes(List<String> value, List<String> ... values) {
            this.workerNodes = Builder._listAdd(this.workerNodes, value, values);
            return this;
        }

        @Override
        @Nonnull
        public ModelProfile build() {
            this._checkSingleUse();
            return new ModelProfile(this);
        }
    }
}

