/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import java.io.Serializable;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.mail.BlobIds;
import org.apache.james.jmap.mail.EmailParseRequest$;
import org.apache.james.jmap.mail.FetchAllBodyValues;
import org.apache.james.jmap.mail.FetchHTMLBodyValues;
import org.apache.james.jmap.mail.FetchTextBodyValues;
import org.apache.james.jmap.mail.RequestTooLargeException;
import org.apache.james.jmap.method.ValidableRequest;
import org.apache.james.jmap.method.WithAccountId;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002\u0017.\u0001bB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00053\"A\u0001\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005g\u0001\tE\t\u0015!\u0003c\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011B5\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001B\u001e\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\to\u0002\u0011)\u001a!C\u0001q\"AQ\u0010\u0001B\tB\u0003%\u0011\u0010\u0003\u0005\u007f\u0001\tU\r\u0011\"\u0001\u0000\u0011)\t)\u0003\u0001B\tB\u0003%\u0011\u0011\u0001\u0005\u000b\u0003O\u0001!Q3A\u0005\u0002\u0005%\u0002BCA\u001a\u0001\tE\t\u0015!\u0003\u0002,!Q\u0011Q\u0007\u0001\u0003\u0016\u0004%\t!!\u000b\t\u0015\u0005]\u0002A!E!\u0002\u0013\tY\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003\u007fB\u0011\"!&\u0001#\u0003%\t!a&\t\u0013\u0005m\u0005!%A\u0005\u0002\u0005u\u0005\"CAQ\u0001E\u0005I\u0011AAR\u0011%\t9\u000bAI\u0001\n\u0003\tI\u000bC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u00020\"I\u00111\u0017\u0001\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003s\u0003\u0011\u0013!C\u0001\u0003kC\u0011\"a/\u0001\u0003\u0003%\t%!0\t\u0013\u0005=\u0007!!A\u0005\u0002\u0005E\u0007\"CAm\u0001\u0005\u0005I\u0011AAn\u0011%\t9\u000fAA\u0001\n\u0003\nI\u000fC\u0005\u0002x\u0002\t\t\u0011\"\u0001\u0002z\"I!1\u0001\u0001\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005\u0013\u0001\u0011\u0011!C!\u0005\u0017A\u0011B!\u0004\u0001\u0003\u0003%\tEa\u0004\t\u0013\tE\u0001!!A\u0005B\tMq!\u0003B\f[\u0005\u0005\t\u0012\u0001B\r\r!aS&!A\t\u0002\tm\u0001bBA\u001dM\u0011\u0005!1\u0007\u0005\n\u0005\u001b1\u0013\u0011!C#\u0005\u001fA\u0011B!\u000e'\u0003\u0003%\tIa\u000e\t\u0013\t%c%!A\u0005\u0002\n-\u0003\"\u0003B-M\u0005\u0005I\u0011\u0002B.\u0005E)U.Y5m!\u0006\u00148/\u001a*fcV,7\u000f\u001e\u0006\u0003]=\nA!\\1jY*\u0011\u0001'M\u0001\u0005U6\f\u0007O\u0003\u00023g\u0005)!.Y7fg*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u001d@\u000b\"[\u0005C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002C_\u00051Q.\u001a;i_\u0012L!\u0001R!\u0003\u001b]KG\u000f[!dG>,h\u000e^%e!\t\u0001e)\u0003\u0002H\u0003\n\u0001b+\u00197jI\u0006\u0014G.\u001a*fcV,7\u000f\u001e\t\u0003u%K!AS\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011A\n\u0016\b\u0003\u001bJs!AT)\u000e\u0003=S!\u0001U\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA*<\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005M[\u0014!C1dG>,h\u000e^%e+\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/0\u0003\u0011\u0019wN]3\n\u0005y[&!C!dG>,h\u000e^%e\u0003)\t7mY8v]RLE\rI\u0001\bE2|'-\u00133t+\u0005\u0011\u0007CA2e\u001b\u0005i\u0013BA3.\u0005\u001d\u0011En\u001c2JIN\f\u0001B\u00197pE&#7\u000fI\u0001\u0013M\u0016$8\r[!mY\n{G-\u001f,bYV,7/F\u0001j!\rQ$\u000e\\\u0005\u0003Wn\u0012aa\u00149uS>t\u0007CA2n\u0013\tqWF\u0001\nGKR\u001c\u0007.\u00117m\u0005>$\u0017PV1mk\u0016\u001c\u0018a\u00054fi\u000eD\u0017\t\u001c7C_\u0012Lh+\u00197vKN\u0004\u0013a\u00054fi\u000eDG+\u001a=u\u0005>$\u0017PV1mk\u0016\u001cX#\u0001:\u0011\u0007iR7\u000f\u0005\u0002di&\u0011Q/\f\u0002\u0014\r\u0016$8\r\u001b+fqR\u0014u\u000eZ=WC2,Xm]\u0001\u0015M\u0016$8\r\u001b+fqR\u0014u\u000eZ=WC2,Xm\u001d\u0011\u0002'\u0019,Go\u00195I)6c%i\u001c3z-\u0006dW/Z:\u0016\u0003e\u00042A\u000f6{!\t\u001970\u0003\u0002}[\t\u0019b)\u001a;dQ\"#V\n\u0014\"pIf4\u0016\r\\;fg\u0006!b-\u001a;dQ\"#V\n\u0014\"pIf4\u0016\r\\;fg\u0002\n\u0011#\\1y\u0005>$\u0017PV1mk\u0016\u0014\u0015\u0010^3t+\t\t\t\u0001\u0005\u0003;U\u0006\r\u0001\u0003BA\u0003\u0003?qA!a\u0002\u0002\u001c9!\u0011\u0011BA\r\u001d\u0011\tY!a\u0006\u000f\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\u0019BD\u0002O\u0003#I\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\r\ti\"L\u0001\u0010\u000b6\f\u0017\u000e\\$fiJ+\u0017/^3ti&!\u0011\u0011EA\u0012\u0005Ei\u0015\r\u001f\"pIf4\u0016\r\\;f\u0005f$Xm\u001d\u0006\u0004\u0003;i\u0013AE7bq\n{G-\u001f,bYV,')\u001f;fg\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t+\t\tY\u0003\u0005\u0003;U\u00065\u0002c\u0001.\u00020%\u0019\u0011\u0011G.\u0003\u0015A\u0013x\u000e]3si&,7/A\u0006qe>\u0004XM\u001d;jKN\u0004\u0013A\u00042pIf\u0004&o\u001c9feRLWm]\u0001\u0010E>$\u0017\u0010\u0015:pa\u0016\u0014H/[3tA\u00051A(\u001b8jiz\"\"#!\u0010\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002NA\u00111\r\u0001\u0005\u0006/F\u0001\r!\u0017\u0005\u0006AF\u0001\rA\u0019\u0005\u0006OF\u0001\r!\u001b\u0005\u0006aF\u0001\rA\u001d\u0005\u0006oF\u0001\r!\u001f\u0005\u0007}F\u0001\r!!\u0001\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002,!9\u0011QG\tA\u0002\u0005-\u0012\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005M\u0013q\f\t\b\u0019\u0006U\u0013\u0011LA\u001f\u0013\r\t9F\u0016\u0002\u0007\u000b&$\b.\u001a:\u0011\u00071\u000bY&C\u0002\u0002^Y\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000f\u0005\u0005$\u00031\u0001\u0002d\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u00042AWA3\u0013\r\t9g\u0017\u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0017\u0001B2paf$\"#!\u0010\u0002n\u0005=\u0014\u0011OA:\u0003k\n9(!\u001f\u0002|!9qk\u0005I\u0001\u0002\u0004I\u0006b\u00021\u0014!\u0003\u0005\rA\u0019\u0005\bON\u0001\n\u00111\u0001j\u0011\u001d\u00018\u0003%AA\u0002IDqa^\n\u0011\u0002\u0003\u0007\u0011\u0010\u0003\u0005\u007f'A\u0005\t\u0019AA\u0001\u0011%\t9c\u0005I\u0001\u0002\u0004\tY\u0003C\u0005\u00026M\u0001\n\u00111\u0001\u0002,\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAAU\rI\u00161Q\u0016\u0003\u0003\u000b\u0003B!a\"\u0002\u00126\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)A\u0005v]\u000eDWmY6fI*\u0019\u0011qR\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0006%%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAMU\r\u0011\u00171Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyJK\u0002j\u0003\u0007\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002&*\u001a!/a!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u0016\u0016\u0004s\u0006\r\u0015AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0003cSC!!\u0001\u0002\u0004\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012:TCAA\\U\u0011\tY#a!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006!A.\u00198h\u0015\t\tI-\u0001\u0003kCZ\f\u0017\u0002BAg\u0003\u0007\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAj!\rQ\u0014Q[\u0005\u0004\u0003/\\$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAo\u0003G\u00042AOAp\u0013\r\t\to\u000f\u0002\u0004\u0003:L\b\"CAs=\u0005\u0005\t\u0019AAj\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001e\t\u0007\u0003[\f\u00190!8\u000e\u0005\u0005=(bAAyw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0018q\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\n\u0005\u0001c\u0001\u001e\u0002~&\u0019\u0011q`\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u001d\u0011\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002@\n\u001d\u0001\"CAsC\u0005\u0005\t\u0019AAj\u0003!A\u0017m\u001d5D_\u0012,GCAAj\u0003!!xn\u0015;sS:<GCAA`\u0003\u0019)\u0017/^1mgR!\u00111 B\u000b\u0011%\t)\u000fJA\u0001\u0002\u0004\ti.A\tF[\u0006LG\u000eU1sg\u0016\u0014V-];fgR\u0004\"a\u0019\u0014\u0014\u000b\u0019\u0012iB!\u000b\u0011#\t}!QE-cSJL\u0018\u0011AA\u0016\u0003W\ti$\u0004\u0002\u0003\")\u0019!1E\u001e\u0002\u000fI,h\u000e^5nK&!!q\u0005B\u0011\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000f\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)!!qFAd\u0003\tIw.C\u0002V\u0005[!\"A!\u0007\u0002\u000b\u0005\u0004\b\u000f\\=\u0015%\u0005u\"\u0011\bB\u001e\u0005{\u0011yD!\u0011\u0003D\t\u0015#q\t\u0005\u0006/&\u0002\r!\u0017\u0005\u0006A&\u0002\rA\u0019\u0005\u0006O&\u0002\r!\u001b\u0005\u0006a&\u0002\rA\u001d\u0005\u0006o&\u0002\r!\u001f\u0005\u0007}&\u0002\r!!\u0001\t\u000f\u0005\u001d\u0012\u00061\u0001\u0002,!9\u0011QG\u0015A\u0002\u0005-\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001b\u0012)\u0006\u0005\u0003;U\n=\u0003C\u0004\u001e\u0003Re\u0013\u0017N]=\u0002\u0002\u0005-\u00121F\u0005\u0004\u0005'Z$A\u0002+va2,\u0007\bC\u0005\u0003X)\n\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tu\u0003\u0003BAa\u0005?JAA!\u0019\u0002D\n1qJ\u00196fGR\u0004")
public class EmailParseRequest
implements WithAccountId,
ValidableRequest,
Product,
Serializable {
    private final AccountId accountId;
    private final BlobIds blobIds;
    private final Option<FetchAllBodyValues> fetchAllBodyValues;
    private final Option<FetchTextBodyValues> fetchTextBodyValues;
    private final Option<FetchHTMLBodyValues> fetchHTMLBodyValues;
    private final Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyValueBytes;
    private final Option<Properties> properties;
    private final Option<Properties> bodyProperties;

    public static Option<Tuple8<AccountId, BlobIds, Option<FetchAllBodyValues>, Option<FetchTextBodyValues>, Option<FetchHTMLBodyValues>, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>>, Option<Properties>, Option<Properties>>> unapply(EmailParseRequest x$0) {
        return EmailParseRequest$.MODULE$.unapply(x$0);
    }

    public static EmailParseRequest apply(AccountId accountId, BlobIds blobIds, Option<FetchAllBodyValues> fetchAllBodyValues, Option<FetchTextBodyValues> fetchTextBodyValues, Option<FetchHTMLBodyValues> fetchHTMLBodyValues, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyValueBytes, Option<Properties> properties, Option<Properties> bodyProperties) {
        return EmailParseRequest$.MODULE$.apply(accountId, blobIds, fetchAllBodyValues, fetchTextBodyValues, fetchHTMLBodyValues, maxBodyValueBytes, properties, bodyProperties);
    }

    public static Function1<Tuple8<AccountId, BlobIds, Option<FetchAllBodyValues>, Option<FetchTextBodyValues>, Option<FetchHTMLBodyValues>, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>>, Option<Properties>, Option<Properties>>, EmailParseRequest> tupled() {
        return EmailParseRequest$.MODULE$.tupled();
    }

    public static Function1<AccountId, Function1<BlobIds, Function1<Option<FetchAllBodyValues>, Function1<Option<FetchTextBodyValues>, Function1<Option<FetchHTMLBodyValues>, Function1<Option<Refined<Object, boolean.Not<numeric.Less<_0>>>>, Function1<Option<Properties>, Function1<Option<Properties>, EmailParseRequest>>>>>>>> curried() {
        return EmailParseRequest$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public AccountId accountId() {
        return this.accountId;
    }

    public BlobIds blobIds() {
        return this.blobIds;
    }

    public Option<FetchAllBodyValues> fetchAllBodyValues() {
        return this.fetchAllBodyValues;
    }

    public Option<FetchTextBodyValues> fetchTextBodyValues() {
        return this.fetchTextBodyValues;
    }

    public Option<FetchHTMLBodyValues> fetchHTMLBodyValues() {
        return this.fetchHTMLBodyValues;
    }

    public Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyValueBytes() {
        return this.maxBodyValueBytes;
    }

    public Option<Properties> properties() {
        return this.properties;
    }

    public Option<Properties> bodyProperties() {
        return this.bodyProperties;
    }

    public Either<Exception, EmailParseRequest> validate(JmapRfc8621Configuration configuration) {
        if ((long)this.blobIds().value().size() > configuration.jmapEmailGetFullMaxSize().asLong()) {
            return new Left((Object)new RequestTooLargeException("Too many items in an email parse request. Got " + this.blobIds().value().size() + " items instead of maximum " + configuration.jmapEmailGetFullMaxSize().asLong() + "."));
        }
        return new Right((Object)this);
    }

    public EmailParseRequest copy(AccountId accountId, BlobIds blobIds, Option<FetchAllBodyValues> fetchAllBodyValues, Option<FetchTextBodyValues> fetchTextBodyValues, Option<FetchHTMLBodyValues> fetchHTMLBodyValues, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyValueBytes, Option<Properties> properties, Option<Properties> bodyProperties) {
        return new EmailParseRequest(accountId, blobIds, fetchAllBodyValues, fetchTextBodyValues, fetchHTMLBodyValues, maxBodyValueBytes, properties, bodyProperties);
    }

    public AccountId copy$default$1() {
        return this.accountId();
    }

    public BlobIds copy$default$2() {
        return this.blobIds();
    }

    public Option<FetchAllBodyValues> copy$default$3() {
        return this.fetchAllBodyValues();
    }

    public Option<FetchTextBodyValues> copy$default$4() {
        return this.fetchTextBodyValues();
    }

    public Option<FetchHTMLBodyValues> copy$default$5() {
        return this.fetchHTMLBodyValues();
    }

    public Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> copy$default$6() {
        return this.maxBodyValueBytes();
    }

    public Option<Properties> copy$default$7() {
        return this.properties();
    }

    public Option<Properties> copy$default$8() {
        return this.bodyProperties();
    }

    public String productPrefix() {
        return "EmailParseRequest";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.accountId();
            }
            case 1: {
                return this.blobIds();
            }
            case 2: {
                return this.fetchAllBodyValues();
            }
            case 3: {
                return this.fetchTextBodyValues();
            }
            case 4: {
                return this.fetchHTMLBodyValues();
            }
            case 5: {
                return this.maxBodyValueBytes();
            }
            case 6: {
                return this.properties();
            }
            case 7: {
                return this.bodyProperties();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EmailParseRequest;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "accountId";
            }
            case 1: {
                return "blobIds";
            }
            case 2: {
                return "fetchAllBodyValues";
            }
            case 3: {
                return "fetchTextBodyValues";
            }
            case 4: {
                return "fetchHTMLBodyValues";
            }
            case 5: {
                return "maxBodyValueBytes";
            }
            case 6: {
                return "properties";
            }
            case 7: {
                return "bodyProperties";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EmailParseRequest)) return false;
        boolean bl = true;
        if (!bl) return false;
        EmailParseRequest emailParseRequest = (EmailParseRequest)x$1;
        AccountId accountId = this.accountId();
        AccountId accountId2 = emailParseRequest.accountId();
        if (accountId == null) {
            if (accountId2 != null) {
                return false;
            }
        } else if (!((Object)accountId).equals(accountId2)) return false;
        BlobIds blobIds = this.blobIds();
        BlobIds blobIds2 = emailParseRequest.blobIds();
        if (blobIds == null) {
            if (blobIds2 != null) {
                return false;
            }
        } else if (!((Object)blobIds).equals(blobIds2)) return false;
        Option<FetchAllBodyValues> option = this.fetchAllBodyValues();
        Option<FetchAllBodyValues> option2 = emailParseRequest.fetchAllBodyValues();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<FetchTextBodyValues> option3 = this.fetchTextBodyValues();
        Option<FetchTextBodyValues> option4 = emailParseRequest.fetchTextBodyValues();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<FetchHTMLBodyValues> option5 = this.fetchHTMLBodyValues();
        Option<FetchHTMLBodyValues> option6 = emailParseRequest.fetchHTMLBodyValues();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> option7 = this.maxBodyValueBytes();
        Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> option8 = emailParseRequest.maxBodyValueBytes();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Properties> option9 = this.properties();
        Option<Properties> option10 = emailParseRequest.properties();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<Properties> option11 = this.bodyProperties();
        Option<Properties> option12 = emailParseRequest.bodyProperties();
        if (option11 == null) {
            if (option12 != null) {
                return false;
            }
        } else if (!option11.equals(option12)) return false;
        if (!emailParseRequest.canEqual(this)) return false;
        return true;
    }

    public EmailParseRequest(AccountId accountId, BlobIds blobIds, Option<FetchAllBodyValues> fetchAllBodyValues, Option<FetchTextBodyValues> fetchTextBodyValues, Option<FetchHTMLBodyValues> fetchHTMLBodyValues, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyValueBytes, Option<Properties> properties, Option<Properties> bodyProperties) {
        this.accountId = accountId;
        this.blobIds = blobIds;
        this.fetchAllBodyValues = fetchAllBodyValues;
        this.fetchTextBodyValues = fetchTextBodyValues;
        this.fetchHTMLBodyValues = fetchHTMLBodyValues;
        this.maxBodyValueBytes = maxBodyValueBytes;
        this.properties = properties;
        this.bodyProperties = bodyProperties;
        Product.$init$((Product)this);
    }
}

