/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.query;

import java.util.stream.Stream;
import org.apache.james.mailbox.model.SearchQuery;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.SortMode;
import org.opensearch.client.opensearch._types.SortOrder;

public class SortConverter {
    private static final String PATH_SEPARATOR = ".";

    public static Stream<FieldSort> convertSort(SearchQuery.Sort sort) {
        return SortConverter.getSortClause(sort.getSortClause()).map(clause -> clause.order(SortConverter.getOrder(sort)).mode(SortMode.Min).build());
    }

    private static Stream<FieldSort.Builder> getSortClause(SearchQuery.Sort.SortClause clause) {
        switch (clause) {
            case Arrival: {
                return Stream.of(new FieldSort.Builder().field("date"));
            }
            case MailboxCc: {
                return Stream.of(new FieldSort.Builder().field("cc.name.raw"), new FieldSort.Builder().field("cc.address.raw"));
            }
            case MailboxFrom: {
                return Stream.of(new FieldSort.Builder().field("from.name.raw"), new FieldSort.Builder().field("cc.address.raw"));
            }
            case MailboxTo: {
                return Stream.of(new FieldSort.Builder().field("to.name.raw"), new FieldSort.Builder().field("cc.address.raw"));
            }
            case BaseSubject: {
                return Stream.of(new FieldSort.Builder().field("subject.raw"));
            }
            case Size: {
                return Stream.of(new FieldSort.Builder().field("size"));
            }
            case SentDate: {
                return Stream.of(new FieldSort.Builder().field("sentDate"));
            }
            case Uid: {
                return Stream.of(new FieldSort.Builder().field("uid"));
            }
            case Id: {
                return Stream.of(new FieldSort.Builder().field("messageId"));
            }
        }
        throw new RuntimeException("Sort is not implemented");
    }

    private static SortOrder getOrder(SearchQuery.Sort sort) {
        if (sort.isReverse()) {
            return SortOrder.Desc;
        }
        return SortOrder.Asc;
    }
}

