/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.CreateClasses;
import org.apache.jena.ontapi.model.CreateDisjoint;
import org.apache.jena.ontapi.model.CreateRanges;
import org.apache.jena.ontapi.model.CreateSWRL;
import org.apache.jena.ontapi.model.IOModel;
import org.apache.jena.ontapi.model.MutableModel;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntFacetRestriction;
import org.apache.jena.ontapi.model.OntID;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.PrefixedModel;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public interface OntModel
extends Model,
MutableModel<OntModel>,
PrefixedModel<OntModel>,
IOModel<OntModel>,
CreateClasses,
CreateRanges,
CreateDisjoint,
CreateSWRL {
    public Graph getBaseGraph();

    public Optional<OntID> id();

    public OntID setID(String var1);

    public OntModel addImport(OntModel var1) throws OntJenaException;

    public OntModel removeImport(OntModel var1);

    public OntModel removeImport(String var1);

    public Stream<OntModel> imports();

    public boolean hasImport(OntModel var1);

    public boolean hasImport(String var1);

    public <O extends OntObject> Stream<O> ontObjects(Class<? extends O> var1);

    public Stream<OntEntity> ontEntities();

    public Stream<OntIndividual> individuals();

    public <E extends OntEntity> E getOntEntity(Class<E> var1, String var2);

    public Stream<OntStatement> statements();

    public Stream<OntStatement> statements(Resource var1, Property var2, RDFNode var3);

    public Stream<OntStatement> localStatements(Resource var1, Property var2, RDFNode var3);

    public OntStatement asStatement(Triple var1);

    public OntModel removeOntObject(OntObject var1);

    public OntModel removeOntStatement(OntStatement var1);

    public <E extends OntEntity> E createOntEntity(Class<E> var1, String var2);

    public <F extends OntFacetRestriction> F createFacetRestriction(Class<F> var1, Literal var2);

    public Model getBaseModel();

    default public InfModel asInferenceModel() {
        throw new OntJenaException.Unsupported("Inference is not supported");
    }

    default public OntID getID() {
        return this.id().orElseGet(() -> this.setID(null));
    }

    default public OntClass.Named createOntClass(String uri) {
        return this.createOntEntity(OntClass.Named.class, Objects.requireNonNull(uri));
    }

    default public OntDataRange.Named createDatatype(String uri) {
        return this.createOntEntity(OntDataRange.Named.class, Objects.requireNonNull(uri));
    }

    default public OntIndividual.Named createIndividual(String uri) {
        return this.createOntEntity(OntIndividual.Named.class, Objects.requireNonNull(uri));
    }

    default public OntProperty createRDFProperty(String uri) {
        return (OntProperty)this.createResource(Objects.requireNonNull(uri)).addProperty(RDF.type, (RDFNode)RDF.Property).as(OntProperty.class);
    }

    default public OntAnnotationProperty createAnnotationProperty(String uri) {
        return this.createOntEntity(OntAnnotationProperty.class, Objects.requireNonNull(uri));
    }

    default public OntDataProperty createDataProperty(String uri) {
        return this.createOntEntity(OntDataProperty.class, Objects.requireNonNull(uri));
    }

    default public OntObjectProperty.Named createObjectProperty(String uri) {
        return this.createOntEntity(OntObjectProperty.Named.class, Objects.requireNonNull(uri));
    }

    default public OntIndividual createIndividual(String uri, OntClass type) {
        OntIndividual res = uri == null ? (OntIndividual)this.createResource().addProperty(RDF.type, (RDFNode)type).as(OntIndividual.class) : this.createIndividual(uri).attachClass(type);
        return res;
    }

    default public OntClass.Named getOntClass(String uri) {
        return this.getOntEntity(OntClass.Named.class, uri);
    }

    default public OntDataRange.Named getDatatype(String uri) {
        return this.getOntEntity(OntDataRange.Named.class, uri);
    }

    default public OntIndividual.Named getIndividual(String uri) {
        return this.getOntEntity(OntIndividual.Named.class, uri);
    }

    default public OntAnnotationProperty getAnnotationProperty(String uri) {
        return this.getOntEntity(OntAnnotationProperty.class, uri);
    }

    default public OntDataProperty getDataProperty(String uri) {
        return this.getOntEntity(OntDataProperty.class, uri);
    }

    default public OntObjectProperty.Named getObjectProperty(String uri) {
        return this.getOntEntity(OntObjectProperty.Named.class, uri);
    }

    default public OntClass.Named getOntClass(Resource uri) {
        return this.getOntClass(uri.getURI());
    }

    default public OntDataRange.Named getDatatype(Resource uri) {
        return this.getDatatype(uri.getURI());
    }

    default public OntIndividual.Named getIndividual(Resource uri) {
        return this.getIndividual(Objects.requireNonNull(uri.getURI()));
    }

    default public OntAnnotationProperty getAnnotationProperty(Resource uri) {
        return this.getAnnotationProperty(uri.getURI());
    }

    default public OntDataProperty getDataProperty(Resource uri) {
        return this.getDataProperty(uri.getURI());
    }

    default public OntObjectProperty.Named getObjectProperty(Resource uri) {
        return this.getObjectProperty(uri.getURI());
    }

    default public Stream<OntStatement> localStatements() {
        return this.localStatements(null, null, null);
    }

    default public <E extends OntEntity> Stream<E> ontEntities(Class<E> type) {
        return this.ontObjects(type);
    }

    default public OntDataRange.Named getDatatype(Literal literal) {
        String uri = literal.getDatatypeURI();
        if (uri != null) {
            return this.getDatatype(uri);
        }
        String lang = literal.getLanguage();
        if (lang != null && !lang.isEmpty()) {
            return this.getDatatype(RDF.langString);
        }
        return this.getDatatype(XSD.xstring);
    }

    default public <E extends OntEntity> E fetchOntEntity(Class<E> type, String uri) {
        E res = this.getOntEntity(type, uri);
        return res == null ? this.createOntEntity(type, uri) : res;
    }

    default public Stream<OntClass.Named> classes() {
        return this.ontEntities(OntClass.Named.class);
    }

    default public Stream<OntClass> hierarchyRoots() {
        return this.ontObjects(OntClass.class).filter(c -> !c.isURIResource() || !c.asNamed().isBuiltIn()).filter(OntClass::isHierarchyRoot);
    }

    default public Stream<OntProperty> properties() {
        return this.ontObjects(OntProperty.class);
    }

    default public Stream<OntAnnotationProperty> annotationProperties() {
        return this.ontEntities(OntAnnotationProperty.class);
    }

    default public Stream<OntDataProperty> dataProperties() {
        return this.ontEntities(OntDataProperty.class);
    }

    default public Stream<OntObjectProperty.Named> objectProperties() {
        return this.ontEntities(OntObjectProperty.Named.class);
    }

    default public Stream<OntDataRange.Named> datatypes() {
        return this.ontEntities(OntDataRange.Named.class);
    }

    default public Stream<OntIndividual.Named> namedIndividuals() {
        return this.ontEntities(OntIndividual.Named.class);
    }

    default public <E extends OntEntity> E getOntEntity(Class<E> type, Resource uri) {
        return this.getOntEntity(type, uri.getURI());
    }

    default public OntAnnotationProperty getRDFSComment() {
        return this.getAnnotationProperty((Resource)RDFS.comment);
    }

    default public OntAnnotationProperty getRDFSLabel() {
        return this.getAnnotationProperty((Resource)RDFS.label);
    }

    default public OntAnnotationProperty getRDFSSeeAlso() {
        return this.getAnnotationProperty((Resource)RDFS.seeAlso);
    }

    default public OntAnnotationProperty getRDFSIsDefinedBy() {
        return this.getAnnotationProperty((Resource)RDFS.isDefinedBy);
    }

    default public OntAnnotationProperty getOWLDeprecated() {
        return this.getAnnotationProperty((Resource)OWL2.deprecated);
    }

    default public OntAnnotationProperty getOWLVersionInfo() {
        return this.getAnnotationProperty((Resource)OWL2.versionInfo);
    }

    default public OntAnnotationProperty getOWLPriorVersion() {
        return this.getAnnotationProperty((Resource)OWL2.priorVersion);
    }

    default public OntAnnotationProperty getOWLBackwardCompatibleWith() {
        return this.getAnnotationProperty((Resource)OWL2.backwardCompatibleWith);
    }

    default public OntAnnotationProperty getOWLIncompatibleWith() {
        return this.getAnnotationProperty((Resource)OWL2.incompatibleWith);
    }

    default public OntClass.Named getOWLThing() {
        return this.getOntClass(OWL2.Thing);
    }

    default public OntClass.Named getOWLNothing() {
        return this.getOntClass(OWL2.Nothing);
    }

    default public OntDataRange.Named getRDFSLiteral() {
        return this.getDatatype(RDFS.Literal);
    }

    default public OntObjectProperty.Named getOWLTopObjectProperty() {
        return this.getObjectProperty((Resource)OWL2.topObjectProperty);
    }

    default public OntObjectProperty.Named getOWLBottomObjectProperty() {
        return this.getObjectProperty((Resource)OWL2.bottomObjectProperty);
    }

    default public OntDataProperty getOWLTopDataProperty() {
        return this.getDataProperty((Resource)OWL2.topDataProperty);
    }

    default public OntDataProperty getOWLBottomDataProperty() {
        return this.getDataProperty((Resource)OWL2.bottomDataProperty);
    }
}

