/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.NodeCmp;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class StdModels {
    public static final Comparator<RDFNode> RDF_NODE_COMPARATOR = (r1, r2) -> NodeCmp.compareRDFTerms((Node)r1.asNode(), (Node)r2.asNode());
    public static final Comparator<Statement> STATEMENT_COMPARATOR = Comparator.comparing(Statement::getSubject, RDF_NODE_COMPARATOR).thenComparing(Statement::getPredicate, RDF_NODE_COMPARATOR).thenComparing(Statement::getObject, RDF_NODE_COMPARATOR);
    public static final RDFNode BLANK = new ResourceImpl();
    public static final Comparator<Statement> STATEMENT_COMPARATOR_IGNORE_BLANK = Comparator.comparing(s -> s.getSubject().isAnon() ? BLANK : s.getSubject(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getPredicate().isAnon() ? BLANK : s.getPredicate(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getObject().isAnon() ? BLANK : s.getObject(), RDF_NODE_COMPARATOR);
    public static final Literal TRUE = ResourceFactory.createTypedLiteral((Object)Boolean.TRUE);
    public static final Literal FALSE = ResourceFactory.createTypedLiteral((Object)Boolean.FALSE);

    public static RDFList createTypedList(Model model, Resource type, Collection<? extends RDFNode> members) {
        return StdModels.createTypedList(model, type, members.iterator());
    }

    public static RDFList createTypedList(Model model, Resource type, Iterator<? extends RDFNode> members) {
        return OntListImpl.createTypedList((EnhGraph)model, type, members);
    }

    public static boolean isInList(Model model, Resource candidate) {
        return model.contains(null, RDF.first, (RDFNode)candidate);
    }

    public static boolean isInList(Statement s) {
        return RDF.first.equals(s.getPredicate()) || RDF.rest.equals(s.getPredicate()) || RDF.nil.equals((Object)s.getObject());
    }

    public static Set<Statement> getListStatements(RDFList list) {
        return ((RDFListImpl)list).collectStatements();
    }

    public static Map<String, String> setNsPrefixes(PrefixMapping mapping, Map<String, String> prefixes) {
        Map init = mapping.getNsPrefixMap();
        init.keySet().forEach(arg_0 -> ((PrefixMapping)mapping).removeNsPrefix(arg_0));
        prefixes.forEach((p, u) -> mapping.setNsPrefix(p.replaceAll(":$", ""), u));
        return init;
    }

    public static String toString(Statement st, PrefixMapping pm) {
        return String.format("[%s, %s, %s]", st.getSubject().asNode().toString(pm), st.getPredicate().asNode().toString(pm), st.getObject().asNode().toString(pm));
    }

    public static String toString(Statement inModel) {
        return StdModels.toString(inModel, (PrefixMapping)inModel.getModel());
    }

    public static boolean containsURI(RDFNode node, String uri) {
        if (node.isURIResource()) {
            return uri.equals(node.asResource().getURI());
        }
        return node.isLiteral() && uri.equals(node.asLiteral().getDatatypeURI());
    }

    public static boolean containsURI(Statement statement, String uri) {
        if (uri.equals(statement.getSubject().getURI())) {
            return true;
        }
        if (uri.equals(statement.getPredicate().getURI())) {
            return true;
        }
        return StdModels.containsURI(statement.getObject(), uri);
    }

    public static StmtIterator createStmtIterator(ExtendedIterator<Triple> triples, Function<Triple, Statement> map) {
        return new StmtIteratorImpl((Iterator)triples.mapWith(map));
    }

    public static Set<Node> asUnmodifiableNodeSet(Collection<? extends RDFNode> nodes) {
        return nodes.stream().map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());
    }

    public static boolean isANY(Resource s, Property p, RDFNode o) {
        if (s != null) {
            return false;
        }
        if (p != null) {
            return false;
        }
        return o == null;
    }

    public static List<Statement> findShortestPath(Model m, Resource start, RDFNode end, Predicate<Statement> onPath) {
        Objects.requireNonNull(m);
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        if (onPath == null) {
            onPath = s -> true;
        }
        ArrayDeque bfs = new ArrayDeque();
        HashSet<Resource> seen = new HashSet<Resource>();
        ExtendedIterator i = m.listStatements(start, null, (RDFNode)null).filterKeep(onPath);
        while (i.hasNext()) {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add((Statement)i.next());
            bfs.add(statements);
        }
        List<Object> solution = new ArrayList<Statement>();
        while (solution.isEmpty() && !bfs.isEmpty()) {
            List candidate = (List)bfs.removeFirst();
            RDFNode terminalNode = candidate.isEmpty() ? null : ((Statement)candidate.get(candidate.size() - 1)).getObject();
            if (terminalNode == null) continue;
            if (end.equals(terminalNode)) {
                solution = candidate;
                continue;
            }
            if (!terminalNode.isResource()) continue;
            Resource terminalResource = terminalNode.asResource();
            seen.add(terminalResource);
            ExtendedIterator i2 = terminalResource.listProperties().filterKeep(onPath);
            while (i2.hasNext()) {
                Statement link = (Statement)i2.next();
                if (seen.contains(link.getObject())) continue;
                ArrayList<Statement> statements = new ArrayList<Statement>(candidate);
                statements.add(link);
                bfs.add(statements);
            }
        }
        return solution;
    }
}

