/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class StrConcat
extends BaseBuiltin {
    @Override
    public String getName() {
        return "strConcat";
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 1) {
            throw new BuiltinException(this, context, "Must have at least 1 argument to " + this.getName());
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < length - 1; ++i) {
            buff.append(this.lex(this.getArg(i, args, context), context));
        }
        Node result = NodeFactory.createLiteralString(buff.toString());
        return context.getEnv().bind(args[length - 1], result);
    }

    protected String lex(Node n, RuleContext context) {
        if (n.isBlank()) {
            return n.getBlankNodeLabel();
        }
        if (n.isURI()) {
            return n.getURI();
        }
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context, "Illegal node type: " + String.valueOf(n));
    }
}

