/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb1.assembler.VocabTDB1;
import org.apache.jena.tdb1.base.file.Location;

public class DatasetAssemblerTDB1
extends DatasetAssembler {
    public DatasetGraph createDataset(Assembler a, Resource root) {
        return DatasetAssemblerTDB1.make(a, root);
    }

    public static DatasetGraph make(Assembler a, Resource root) {
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabTDB1.pLocation)) {
            throw new AssemblerException(root, "No location given");
        }
        String dir = GraphUtils.getStringValue((Resource)root, (Property)VocabTDB1.pLocation);
        Location loc = Location.create(dir);
        DatasetGraph dsg = TDB1Factory.createDatasetGraph(loc);
        if (root.hasProperty(VocabTDB1.pUnionDefaultGraph)) {
            Node b = root.getProperty(VocabTDB1.pUnionDefaultGraph).getObject().asNode();
            NodeValue nv = NodeValue.makeNode((Node)b);
            if (nv.isBoolean()) {
                dsg.getContext().set(TDB1.symUnionDefaultGraph, nv.getBoolean());
            } else {
                Log.warn(DatasetAssemblerTDB1.class, (String)("Failed to recognize value for union graph setting (ignored): " + String.valueOf(b)));
            }
        }
        AssemblerUtils.mergeContext((Resource)root, (Context)dsg.getContext());
        return dsg;
    }

    static {
        JenaSystem.init();
    }
}

