/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.index;

import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.BuilderStdIndex;
import org.apache.jena.tdb1.index.Index;
import org.apache.jena.tdb1.index.IndexBuilder;
import org.apache.jena.tdb1.index.IndexParams;
import org.apache.jena.tdb1.index.RangeIndex;
import org.apache.jena.tdb1.index.RangeIndexBuilder;
import org.apache.jena.tdb1.setup.BlockMgrBuilder;
import org.apache.jena.tdb1.setup.StoreParams;

public class IndexFactory {
    private static BlockMgrBuilder blockMgrBuilder = new BuilderStdIndex.BlockMgrBuilderStd();
    private static RangeIndexBuilder rangeIndexBuilder = new BuilderStdIndex.RangeIndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
    private static IndexBuilder indexBuilder = new BuilderStdIndex.IndexBuilderStd(blockMgrBuilder, blockMgrBuilder);

    public static IndexBuilder createIndexBuilderMem() {
        return IndexFactory.createIndexBuilder(IndexFactory.createRangeIndexBuilderMem());
    }

    public static IndexBuilder createIndexBuilder(final RangeIndexBuilder other) {
        return new IndexBuilder(){

            @Override
            public Index buildIndex(FileSet fileSet, RecordFactory recordfactory, IndexParams indexParams) {
                return other.buildRangeIndex(fileSet, recordfactory, indexParams);
            }
        };
    }

    public static RangeIndexBuilder createRangeIndexBuilderMem() {
        return new BuilderStdIndex.RangeIndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
    }

    public static RangeIndex buildRangeIndexMem(RecordFactory recordFactory) {
        FileSet fileSet = FileSet.mem();
        return IndexFactory.buildRangeIndex(fileSet, recordFactory);
    }

    public static RangeIndex buildRangeIndex(Location location, String indexName, RecordFactory recordFactory) {
        FileSet fileset = new FileSet(location, indexName);
        return IndexFactory.buildRangeIndex(fileset, recordFactory);
    }

    public static RangeIndex buildRangeIndex(Location location, String indexName, RecordFactory recordFactory, IndexParams indexParams) {
        FileSet fileset = new FileSet(location, indexName);
        return IndexFactory.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static RangeIndex buildRangeIndex(FileSet fileset, RecordFactory recordFactory) {
        StoreParams indexParams = StoreParams.getDftStoreParams();
        return IndexFactory.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static RangeIndex buildRangeIndex(FileSet fileset, RecordFactory recordFactory, IndexParams indexParams) {
        return rangeIndexBuilder.buildRangeIndex(fileset, recordFactory, indexParams);
    }

    public static Index buildIndexMem(RecordFactory recordFactory) {
        FileSet fileSet = FileSet.mem();
        return IndexFactory.buildIndex(fileSet, recordFactory);
    }

    public static Index buildIndex(FileSet fileset, RecordFactory recordFactory) {
        StoreParams indexParams = StoreParams.getDftStoreParams();
        return IndexFactory.buildIndex(fileset, recordFactory, indexParams);
    }

    public static Index buildIndex(FileSet fileset, RecordFactory recordFactory, IndexParams indexParams) {
        return indexBuilder.buildIndex(fileset, recordFactory, indexParams);
    }
}

