/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.langtag.InternalLangTag;
import org.apache.jena.langtag.LangTag;

public final class LangTagRE
implements LangTag {
    private final String string;
    private final String[] parts;
    static final int idxLanguage = 0;
    static final int idxScript = 1;
    static final int idxRegion = 2;
    static final int idxVariant = 3;
    static final int idxExtension = 4;
    static final int idxPrivateUse = 5;

    public static LangTag create(String string) {
        LangTagRE langTagRE = new LangTagRE(string);
        return langTagRE;
    }

    private LangTagRE(String string) {
        this.string = string;
        this.parts = LangTagByRE.parse(string);
    }

    @Override
    public String str() {
        return null;
    }

    @Override
    public String getLanguage() {
        return this.parts[0];
    }

    @Override
    public String getScript() {
        return this.parts[1];
    }

    @Override
    public String getRegion() {
        return this.parts[2];
    }

    @Override
    public String getVariant() {
        return this.parts[3];
    }

    @Override
    public String getExtension() {
        return this.parts[4];
    }

    @Override
    public String getPrivateUse() {
        return this.parts[5];
    }

    static class LangTagByRE {
        private static final int partsLength = 6;
        private static final String languageRE_1 = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})";
        private static final String languageRE_2 = "[a-zA-Z]{4}";
        private static final String languageRE_3 = "[a-zA-Z]{5,8}";
        private static final String language = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}";
        private static final String script = "[a-zA-Z]{4}";
        private static final String region = "[a-zA-Z]{2}|[0-9]{3}";
        private static final String variant1 = "(?:[a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3})";
        private static final String variant = "(?:[a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3})(?:-(?:[a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3}))*";
        private static final String extension1 = "(?:[a-wyzA-WYZ0-9](?:-[a-zA-Z0-9]{2,8})+)";
        private static final String extension = "(?:[a-wyzA-WYZ0-9](?:-[a-zA-Z0-9]{2,8})+)(?:-(?:[a-wyzA-WYZ0-9](?:-[a-zA-Z0-9]{2,8})+))*";
        private static final String privateuse = "[xX](?:-[a-zA-Z0-9]{1,8})+";
        private static final String langtag = String.format("^(%s)(?:-(%s))?(?:-(%s))?(?:-(%s))*(?:-(%s))?(?:-(%s))?$", "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}", "[a-zA-Z]{4}", "[a-zA-Z]{2}|[0-9]{3}", "(?:[a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3})(?:-(?:[a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3}))*", "(?:[a-wyzA-WYZ0-9](?:-[a-zA-Z0-9]{2,8})+)(?:-(?:[a-wyzA-WYZ0-9](?:-[a-zA-Z0-9]{2,8})+))*", "[xX](?:-[a-zA-Z0-9]{1,8})+");
        private static final String grandfatheredRE = "^i(?:-[a-zA-Z0-9]{2,8}){1,2}$";
        private static final String privateUseLangRE = "^[xX](?:-[a-zA-Z0-9]{1,8})+$";
        private static Pattern pattern = Pattern.compile(langtag);
        private static Pattern patternGrandfathered = Pattern.compile("^i(?:-[a-zA-Z0-9]{2,8}){1,2}$");
        private static Pattern privateUseLang = Pattern.compile("^[xX](?:-[a-zA-Z0-9]{1,8})+$");
        private static Pattern enOED = Pattern.compile("en-GB-oed", 2);

        private LangTagByRE() {
        }

        static boolean check(String languageTag) {
            int len = languageTag.length();
            int idx = 0;
            boolean first = true;
            while (idx < languageTag.length()) {
                int idx2 = LangTagByRE.checkPart(languageTag, idx, first);
                first = false;
                if (idx2 == idx) {
                    return false;
                }
                idx = idx2;
                if (idx == len) {
                    return true;
                }
                if (languageTag.charAt(idx) != '-') {
                    return false;
                }
                if (++idx != len) continue;
                return false;
            }
            return true;
        }

        private static int checkPart(String languageTag, int idx, boolean leader) {
            while (idx < languageTag.length()) {
                char ch = languageTag.charAt(idx);
                if (!(leader ? InternalLangTag.isA2Z(ch) : InternalLangTag.isA2ZN(ch))) {
                    return idx;
                }
                ++idx;
            }
            return idx;
        }

        static String[] parse(String languageTag) {
            String[] parts = new String[6];
            Matcher m = pattern.matcher(languageTag);
            if (!m.find()) {
                m = patternGrandfathered.matcher(languageTag);
                if (m.find()) {
                    parts[0] = m.group(0);
                    return parts;
                }
                m = privateUseLang.matcher(languageTag);
                if (m.find()) {
                    parts[5] = m.group(0);
                    return parts;
                }
                m = enOED.matcher(languageTag);
                if (m.find()) {
                    parts[0] = "en";
                    parts[2] = "GB";
                    parts[3] = "oed";
                    return parts;
                }
                return null;
            }
            int gc = m.groupCount();
            for (int i = 0; i < gc; ++i) {
                parts[i] = m.group(i + 1);
            }
            parts[0] = LangTagByRE.lowercase(parts[0]);
            parts[1] = LangTagByRE.titlecase(parts[1]);
            parts[2] = LangTagByRE.uppercase(parts[2]);
            parts[3] = LangTagByRE.lowercase(parts[3]);
            parts[4] = LangTagByRE.lowercase(parts[4]);
            parts[5] = LangTagByRE.lowercase(parts[5]);
            return parts;
        }

        static String canonical(String str) {
            if (str == null) {
                return null;
            }
            String[] parts = LangTagByRE.parse(str);
            String x = LangTagByRE.canonical(parts);
            if (x == null) {
                return str;
            }
            return x;
        }

        static String canonical(String[] parts) {
            if (parts == null) {
                return null;
            }
            if (parts[0] == null) {
                return parts[4];
            }
            StringBuilder sb = new StringBuilder();
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i] == null) continue;
                sb.append("-");
                sb.append(parts[i]);
            }
            return sb.toString();
        }

        private static String strcase_unused(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() == 2) {
                return LangTagByRE.uppercase(string);
            }
            if (string.length() == 4) {
                return LangTagByRE.titlecase(string);
            }
            return LangTagByRE.lowercase(string);
        }

        private static String lowercase(String string) {
            if (string == null) {
                return null;
            }
            return string.toLowerCase(Locale.ROOT);
        }

        private static String uppercase(String string) {
            if (string == null) {
                return null;
            }
            return string.toUpperCase(Locale.ROOT);
        }

        private static String titlecase(String string) {
            if (string == null) {
                return null;
            }
            char ch1 = string.charAt(0);
            ch1 = Character.toUpperCase(ch1);
            string = LangTagByRE.lowercase(string.substring(1));
            return ch1 + string;
        }
    }
}

