/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb1.solver.SolverLibTDB;
import org.apache.jena.tdb1.solver.stats.Stats;
import org.apache.jena.tdb1.solver.stats.StatsCollectorNodeId;
import org.apache.jena.tdb1.solver.stats.StatsResults;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbstats
extends CmdTDBGraph {
    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbstats(argv).mainRun();
    }

    protected tdbstats(String[] argv) {
        super(argv);
    }

    @Override
    protected String getSummary() {
        return null;
    }

    public static StatsResults stats(DatasetGraphTDB dsg, Node gn) {
        NodeTable nt = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        StatsCollectorNodeId stats = new StatsCollectorNodeId(nt);
        if (gn == null) {
            Iterator iter = dsg.getTripleTable().getNodeTupleTable().findAll();
            while (iter.hasNext()) {
                Tuple t = (Tuple)iter.next();
                stats.record(null, (Object)((NodeId)t.get(0)), (Object)((NodeId)t.get(1)), (Object)((NodeId)t.get(2)));
            }
        } else {
            Iterator iter;
            boolean unionGraph = Quad.isUnionGraph((Node)gn);
            NodeId gnid = null;
            if (!unionGraph && NodeId.isDoesNotExist((NodeId)(gnid = nt.getNodeIdForNode(gn)))) {
                Log.warn(tdbstats.class, (String)("No such graph: " + String.valueOf(gn)));
            }
            NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
            Iterator iterator = iter = unionGraph ? SolverLibTDB.unionGraph((NodeTupleTable)ntt) : ntt.find(new NodeId[]{gnid, null, null, null});
            while (iter.hasNext()) {
                Tuple t = (Tuple)iter.next();
                stats.record((Object)((NodeId)t.get(0)), (Object)((NodeId)t.get(1)), (Object)((NodeId)t.get(2)), (Object)((NodeId)t.get(3)));
            }
        }
        return stats.results();
    }

    @Override
    protected void exec() {
        DatasetGraphTDB dsg = this.getDatasetGraphTDB();
        Node gn = this.getGraphName();
        StatsResults results = tdbstats.stats(dsg, gn);
        Stats.write((OutputStream)System.out, (StatsResults)results);
    }
}

