/*
 * Decompiled with CFR 0.152.
 */
package tdb2;

import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BinaryDataFileRandomAccess;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb2.store.nodetable.TReadAppendFileTransport;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class tdbdumpnodes {
    public static void main(String ... args) throws TException {
        long locn;
        if (args.length != 1) {
            System.err.println("Usage: tdbdumpnodes NodeFile -- e.g \"Database2/Data-0001/nodes-data.dat\"");
            System.exit(1);
        }
        String FN = args[0];
        BinaryDataFileRandomAccess f = new BinaryDataFileRandomAccess(FN);
        f.open();
        TReadAppendFileTransport transport = new TReadAppendFileTransport((BinaryDataFile)f);
        TProtocol protocol = TRDF.protocol((TTransport)transport);
        transport.readPosition(0L);
        long limit = f.length();
        System.out.printf("File length: %,d [0x%16X]\n", limit, limit);
        while ((locn = transport.readPosition()) < limit) {
            try {
                Node n = tdbdumpnodes.readOne(protocol);
                System.out.printf("[0x%16X] %s\n", locn, FmtUtils.stringForNode((Node)n));
            }
            catch (Exception ex) {
                long i;
                System.out.printf("[0x%16X] ** Bad read ** %s\n", locn, ex.getMessage());
                long jump = 100L;
                for (i = locn; i < locn + jump; ++i) {
                    transport.readPosition(i);
                    try {
                        Node n = tdbdumpnodes.readOne(protocol);
                        System.out.printf("Resync: %,d  [0x%16X] ==> [0x%16X]\n", i - locn, locn, i);
                        System.out.printf("[0x%16X] ** %s\n", locn, FmtUtils.stringForNode((Node)n));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (locn - i < jump) continue;
                System.out.printf("No resync: %,d  [0x%16X] ==> [0x%16X]\n", i - locn, locn, i);
            }
        }
    }

    private static Node readOne(TProtocol protocol) throws TException {
        RDF_Term term = new RDF_Term();
        term.read(protocol);
        Node n = ThriftConvert.convert((RDF_Term)term);
        return n;
    }
}

