/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.web.HttpSC;

public class HttpException
extends RuntimeException {
    private final int statusCode;
    private final String statusLine;
    private final String response;

    public HttpException(int statusCode) {
        this(statusCode, null);
    }

    public HttpException(int statusCode, String statusLine) {
        this(statusCode, statusLine, null, null);
    }

    public HttpException(int statusCode, String statusLine, String responseMessage) {
        this(statusCode, statusLine, responseMessage, null);
    }

    public HttpException(int statusCode, String statusLine, String responseMessage, Throwable cause) {
        super(HttpException.exMessage(statusCode, statusLine), cause);
        this.statusCode = statusCode;
        this.statusLine = statusLine;
        this.response = responseMessage;
    }

    private static String exMessage(int statusCode, String statusLine) {
        if (statusLine == null) {
            statusLine = HttpSC.getMessage(statusCode);
        }
        return statusCode + " - " + HttpSC.getMessage(statusCode);
    }

    public HttpException(String message) {
        super(message);
        this.statusCode = -1;
        this.statusLine = null;
        this.response = null;
    }

    public HttpException(String message, Throwable cause) {
        super(message, cause);
        this.statusCode = -1;
        this.statusLine = null;
        this.response = null;
    }

    public HttpException(Throwable cause) {
        super(cause);
        this.statusCode = -1;
        this.statusLine = null;
        this.response = null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public String getResponse() {
        return this.response;
    }
}

