/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ConstRDFS {
    public static final Node ANY = Node.ANY;
    public static final Node rdfType = RDF.Nodes.type;
    public static final Node rdfsRange = RDFS.Nodes.range;
    public static final Node rdfsDomain = RDFS.Nodes.domain;
    public static final Node rdfsSubClassOf = RDFS.Nodes.subClassOf;
    public static final Node rdfsSubPropertyOf = RDFS.Nodes.subPropertyOf;
    private static Set<Node> vocabTerms = new HashSet<Node>();
    public static Predicate<Triple> filterRDFS;
    public static Predicate<Triple> filterNotRDFS;

    static {
        vocabTerms.add(rdfsRange);
        vocabTerms.add(rdfsDomain);
        vocabTerms.add(rdfsSubClassOf);
        vocabTerms.add(rdfsSubPropertyOf);
        filterRDFS = triple -> vocabTerms.contains(triple.getPredicate());
        filterNotRDFS = filterRDFS.negate();
    }
}

