/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LangJSONLD11;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.protobuf.ProtobufRDF;
import org.apache.jena.riot.protobuf.RiotProtobufException;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.riot.thrift.ThriftRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.util.Context;

public class RiotParsers {
    public static ReaderRIOTFactory factoryTTL = (lang, parserProfile) -> new ReaderRIOTLangTTL(parserProfile);
    public static ReaderRIOTFactory factoryTRIG = (lang, parserProfile) -> new ReaderRIOTLangTriG(parserProfile);
    public static ReaderRIOTFactory factoryNT = (lang, parserProfile) -> new ReaderRIOTLangNTriples(parserProfile);
    public static ReaderRIOTFactory factoryNQ = (lang, parserProfile) -> new ReaderRIOTLangNQuads(parserProfile);
    public static ReaderRIOTFactory factoryRDFThrift = (language, profile) -> new ReaderRDFThrift(profile);
    public static ReaderRIOTFactory factoryRDFProtobuf = (language, profile) -> new ReaderRDFProtobuf(profile);
    public static ReaderRIOTFactory factoryJSONLD = (language, profile) -> new LangJSONLD11(language, profile, profile.getErrorHandler());
    public static ReaderRIOTFactory factoryRDFJSON = (language, profile) -> new ReaderRIOT_RDFJSON(profile);

    private RiotParsers() {
    }

    private static class ReaderRIOT_RDFJSON
    implements ReaderRIOT {
        private final ParserProfile parserProfile;

        ReaderRIOT_RDFJSON(ParserProfile parserProfile) {
            this.parserProfile = parserProfile;
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8((InputStream)in));
            LangRDFJSON parser = new LangRDFJSON((Tokenizer)tokenizer, this.parserProfile, output);
            parser.parse();
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.make((Reader)reader));
            LangRDFJSON parser = new LangRDFJSON((Tokenizer)tokenizer, this.parserProfile, output);
            parser.parse();
        }
    }

    private static class ReaderRDFProtobuf
    implements ReaderRIOT {
        private final ParserProfile profile;

        public ReaderRDFProtobuf(ParserProfile profile) {
            this.profile = profile;
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            try {
                ProtobufRDF.inputStreamToStreamRDF(in, output);
            }
            catch (RiotProtobufException ex) {
                if (this.profile != null && this.profile.getErrorHandler() != null) {
                    this.profile.getErrorHandler().error(ex.getMessage(), -1L, -1L);
                } else {
                    ErrorHandlerFactory.errorHandlerStd.error(ex.getMessage(), -1L, -1L);
                }
                throw ex;
            }
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            throw new RiotException("RDF Protobuf : Reading binary data from a java.io.reader is not supported. Please use an InputStream");
        }
    }

    private static class ReaderRDFThrift
    implements ReaderRIOT {
        private final ParserProfile profile;

        public ReaderRDFThrift(ParserProfile profile) {
            this.profile = profile;
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            try {
                ThriftRDF.inputStreamToStream(in, output);
            }
            catch (RiotThriftException ex) {
                if (this.profile != null && this.profile.getErrorHandler() != null) {
                    this.profile.getErrorHandler().error(ex.getMessage(), -1L, -1L);
                } else {
                    ErrorHandlerFactory.errorHandlerStd.error(ex.getMessage(), -1L, -1L);
                }
                throw ex;
            }
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            throw new RiotException("RDF Thrift : Reading binary data from a java.io.reader is not supported. Please use an InputStream");
        }
    }

    private static class ReaderRIOTLangNQuads
    extends AbstractReaderRIOTLang {
        ReaderRIOTLangNQuads(ParserProfile parserProfile) {
            super(Lang.NQUADS, parserProfile);
        }

        @Override
        protected LangRIOT create(Tokenizer tokenizer, StreamRDF output, Context context2) {
            return new LangNQuads(tokenizer, this.parserProfile, output);
        }
    }

    private static class ReaderRIOTLangNTriples
    extends AbstractReaderRIOTLang {
        ReaderRIOTLangNTriples(ParserProfile parserProfile) {
            super(Lang.NTRIPLES, parserProfile);
        }

        @Override
        protected LangRIOT create(Tokenizer tokenizer, StreamRDF output, Context context2) {
            return new LangNTriples(tokenizer, this.parserProfile, output);
        }
    }

    private static class ReaderRIOTLangTriG
    extends AbstractReaderRIOTLang {
        ReaderRIOTLangTriG(ParserProfile parserProfile) {
            super(Lang.TRIG, parserProfile);
        }

        @Override
        protected LangRIOT create(Tokenizer tokenizer, StreamRDF output, Context context2) {
            return new LangTriG(tokenizer, this.parserProfile, output);
        }
    }

    private static class ReaderRIOTLangTTL
    extends AbstractReaderRIOTLang {
        ReaderRIOTLangTTL(ParserProfile parserProfile) {
            super(Lang.TURTLE, parserProfile);
        }

        @Override
        protected LangRIOT create(Tokenizer tokenizer, StreamRDF output, Context context2) {
            return new LangTurtle(tokenizer, this.parserProfile, output);
        }
    }

    private static class ReaderRIOTFactoryJSONLD11
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryJSONLD11() {
        }

        @Override
        public ReaderRIOT create(Lang language, ParserProfile profile) {
            if (!Lang.JSONLD.equals(language) && !Lang.JSONLD11.equals(language)) {
                throw new InternalErrorException("Attempt to parse " + String.valueOf(language) + " as JSON-LD 1.1");
            }
            return new LangJSONLD11(language, profile, profile.getErrorHandler());
        }
    }

    private static abstract class AbstractReaderRIOTLang
    implements ReaderRIOT {
        protected final Lang lang;
        protected final ParserProfile parserProfile;

        AbstractReaderRIOTLang(Lang lang, ParserProfile parserProfile) {
            this.lang = lang;
            this.parserProfile = parserProfile;
        }

        @Override
        public void read(InputStream input, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(this.parserProfile.getErrorHandler()).build();
            this.read(tokenizer, output, context2);
        }

        private void checkParserProfile(ParserProfile parserProfile, String baseURI) {
            String parserProfileBase;
            if (!Lang.NTRIPLES.equals(this.lang) && !Lang.NQUADS.equals(this.lang) && (parserProfileBase = parserProfile.getBaseURI()) == null && baseURI != null) {
                parserProfile.setBaseIRI(baseURI);
            }
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            this.checkParserProfile(this.parserProfile, baseURI);
            Tokenizer tokenizer = TokenizerText.create().source(reader).errorHandler(this.parserProfile.getErrorHandler()).build();
            this.read(tokenizer, output, context2);
        }

        protected void read(Tokenizer tokenizer, StreamRDF output, Context context2) {
            LangRIOT parser = this.create(tokenizer, output, context2);
            parser.parse();
        }

        protected abstract LangRIOT create(Tokenizer var1, StreamRDF var2, Context var3);
    }
}

