/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;

public abstract class BindingProjectBase
extends BindingBase {
    private List<Var> actualVars = null;
    protected final Binding binding;

    public BindingProjectBase(Binding bind) {
        super(null);
        this.binding = bind;
    }

    protected abstract boolean accept(Var var1);

    @Override
    protected boolean contains1(Var var) {
        return this.accept(var) && this.binding.contains(var);
    }

    @Override
    protected Node get1(Var var) {
        if (!this.accept(var)) {
            return null;
        }
        return this.binding.get(var);
    }

    @Override
    protected Iterator<Var> vars1() {
        return this.actualVars().iterator();
    }

    private List<Var> actualVars() {
        if (this.actualVars == null) {
            this.actualVars = new ArrayList<Var>();
            Iterator<Var> iter = this.binding.vars();
            while (iter.hasNext()) {
                Var v = iter.next();
                if (!this.accept(v)) continue;
                this.actualVars.add(v);
            }
        }
        return this.actualVars;
    }

    @Override
    protected int size1() {
        return this.actualVars().size();
    }

    @Override
    protected boolean isEmpty1() {
        if (this.binding.isEmpty()) {
            return true;
        }
        return this.size1() == 0;
    }
}

