/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;

public class Timer {
    protected long timeFinish = -1L;
    protected boolean inTimer = false;
    protected long timeStart = 0L;

    public Timer startTimer() {
        if (this.inTimer) {
            throw new AtlasException("Already in timer");
        }
        this.timeStart = System.currentTimeMillis();
        this.timeFinish = -1L;
        this.inTimer = true;
        return this;
    }

    public long endTimer() {
        if (!this.inTimer) {
            throw new AtlasException("Not in timer");
        }
        this.timeFinish = System.currentTimeMillis();
        this.inTimer = false;
        return this.getTimeInterval();
    }

    public long read() {
        return this.inTimer ? System.currentTimeMillis() - this.timeStart : this.timeFinish - this.timeStart;
    }

    public long readTimer() {
        if (!this.inTimer) {
            throw new AtlasException("Not in timer");
        }
        return this.read();
    }

    public long getTimeInterval() {
        if (this.inTimer) {
            throw new AtlasException("Still timing");
        }
        if (this.timeFinish == -1L) {
            throw new AtlasException("No valid interval");
        }
        return this.read();
    }

    public static String timeStr(long timeInterval) {
        return String.format("%.3f", (double)timeInterval / 1000.0);
    }

    protected String timeStr(long timePoint, long startTimePoint) {
        return Timer.timeStr(timePoint - startTimePoint);
    }

    public static long time(Runnable action) {
        Timer timer = new Timer();
        timer.startTimer();
        action.run();
        long x = timer.endTimer();
        return x;
    }
}

