/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.eval;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.system.G;

class ShapeEvalTripleConstraint {
    ShapeEvalTripleConstraint() {
    }

    static boolean matchesCardinalityTC(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleConstraint tripleConstraint, Set<Node> extras) {
        Node predicate = tripleConstraint.getPredicate();
        if (tripleConstraint.reverse()) {
            matchables = G.find((Graph)vCxt.getData(), null, (Node)predicate, (Node)node).toSet();
        } else if (!matchables.stream().allMatch(t -> predicate.equals((Object)t.getPredicate()))) {
            return false;
        }
        Set triples = StreamOps.toSet(matchables.stream().filter(t -> predicate.equals((Object)t.getPredicate())));
        int min = tripleConstraint.min();
        int max = tripleConstraint.max();
        ShapeExpression shExpr = tripleConstraint.getShapeExpression();
        Set positive = triples.stream().filter(t -> {
            Node v = tripleConstraint.reverse() ? t.getSubject() : t.getObject();
            return shExpr.satisfies(vCxt, v);
        }).collect(Collectors.toSet());
        int N = positive.size();
        if (min >= 0 && N < min) {
            vCxt.reportEntry(new ReportItem("Cardinality violation (min=" + min + "): " + N, null));
            return false;
        }
        if (!(extras != null && extras.contains(predicate) || positive.size() == triples.size())) {
            return false;
        }
        if (max >= 0 && N > max) {
            vCxt.reportEntry(new ReportItem("Cardinality violation (max=" + max + "): " + N, null));
            return false;
        }
        boolean b = tripleConstraint.testSemanticActions(vCxt, matchables);
        return b;
    }
}

