/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;

public final class OutStreamUTF8
extends Writer {
    private OutputStream out;

    public OutStreamUTF8(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        OutStreamUTF8.output(this.out, ch);
    }

    @Override
    public void write(char[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(String str2) throws IOException {
        this.write(str2, 0, str2.length());
    }

    @Override
    public void write(String str2, int idx, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(str2.charAt(idx + i));
        }
    }

    public void output(int x) {
        try {
            OutStreamUTF8.output(this.out, x);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static byte[] encode(int ch) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream(8);
        try {
            OutStreamUTF8.output(out, ch);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                IO.exception(ex);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public static void output(OutputStream out, int ch) throws IOException {
        if (ch != 0 && ch <= 127) {
            out.write(ch);
            return;
        }
        if (ch == 0) {
            out.write(192);
            out.write(128);
            return;
        }
        if (ch <= 2047) {
            int x1 = ch >> 6 & 0x1F | 0xC0;
            int x2 = ch & 0x3F | 0x80;
            out.write(x1);
            out.write(x2);
            return;
        }
        if (ch <= 65535) {
            int x1 = ch >> 12 & 0xF | 0xE0;
            int x2 = ch >> 6 & 0x3F | 0x80;
            int x3 = ch & 0x3F | 0x80;
            out.write(x1);
            out.write(x2);
            out.write(x3);
            return;
        }
        if (ch <= 0x1FFFFF) {
            int x1 = ch >> 18 & 7 | 0xF0;
            OutStreamUTF8.outputBytes(out, x1, 4, ch);
            return;
        }
        if (ch <= 0x3FFFFFF) {
            int x1 = ch >> 24 & 3 | 0xF8;
            OutStreamUTF8.outputBytes(out, x1, 5, ch);
            return;
        }
        if (ch <= Integer.MAX_VALUE) {
            int x1 = ch >> 31 & 1 | 0xFC;
            OutStreamUTF8.outputBytes(out, x1, 6, ch);
            return;
        }
    }

    private static void outputBytes(OutputStream out, int x1, int byteLength, int ch) throws IOException {
        out.write(x1);
        --byteLength;
        for (int i = 0; i < byteLength; ++i) {
            int shift = 6 * (byteLength - i - 1);
            int x = ch >> shift & 0x3F;
            out.write(x |= 0x80);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

