/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.WebContent;
import org.apache.jena.shared.OperationDeniedException;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class SPARQL_Update
extends ActionService {
    private static final String UpdateParseBase = "http://server/unset-base/";
    private static final IRIxResolver resolver = IRIxResolver.create().base("http://server/unset-base/").resolve(true).allowRelative(false).build();
    protected static List<String> paramsForm = Arrays.asList("request", "update", "using-graph-uri", "using-named-graph-uri");
    protected static List<String> paramsPOST = Arrays.asList("using-graph-uri", "using-named-graph-uri");

    @Override
    public void execOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "POST,PATCH,OPTIONS");
        ServletOps.success(action);
    }

    @Override
    public void execGet(HttpAction action) {
        ServletOps.errorMethodNotAllowed("GET", "SPARQL Update is not supported with GET. Use POST or PATCH instead");
    }

    @Override
    public void execPost(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execPatch(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execute(HttpAction action) {
        ContentType ct = SPARQL_Update.updateContentType(action);
        if (WebContent.matchContentType(WebContent.ctSPARQLUpdate, ct)) {
            this.executeBody(action);
            return;
        }
        if (WebContent.isHtmlForm(ct)) {
            this.executeForm(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + action.getRequestContentType());
    }

    @Override
    public void validate(HttpAction action) {
        ContentType ct;
        if ("OPTIONS".equals(action.getRequestMethod())) {
            return;
        }
        if (!"POST".equalsIgnoreCase(action.getRequestMethod()) && !"PATCH".equalsIgnoreCase(action.getRequestMethod())) {
            ServletOps.errorMethodNotAllowed("SPARQL Update : use POST or PATCH");
        }
        if (WebContent.matchContentType(WebContent.ctSPARQLUpdate, ct = SPARQL_Update.updateContentType(action))) {
            String charset = action.getRequestCharacterEncoding();
            if (charset != null && !charset.equalsIgnoreCase("utf-8")) {
                ServletOps.errorBadRequest("Bad charset: " + charset);
            }
            this.validate(action, paramsPOST);
            return;
        }
        if (WebContent.isHtmlForm(ct)) {
            String requestStr;
            int x = SPARQLProtocol.countParamOccurences(action.getRequest(), "update") + SPARQLProtocol.countParamOccurences(action.getRequest(), "request");
            if (x == 0) {
                ServletOps.errorBadRequest("SPARQL Update: No 'update=' parameter");
            }
            if (x != 1) {
                ServletOps.errorBadRequest("SPARQL Update: Multiple 'update=' parameters");
            }
            if ((requestStr = action.getRequestParameter("update")) == null) {
                requestStr = action.getRequestParameter("request");
            }
            if (requestStr == null) {
                ServletOps.errorBadRequest("SPARQL Update: No update= in HTML form");
            }
            this.validate(action, paramsForm);
            return;
        }
        ServletOps.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded (got " + ct.getContentTypeStr() + ")");
    }

    protected void validate(HttpAction action, Collection<String> params) {
        if (params != null) {
            Enumeration<String> en = action.getRequestParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Update: Unrecognized request parameter (ignored): " + name);
            }
        }
    }

    private void executeBody(HttpAction action) {
        InputStream input = null;
        try {
            input = action.getRequestInputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        if (action.verbose) {
            byte[] bytes = IO.readWholeFile(input);
            input = new ByteArrayInputStream(bytes);
            try {
                String requestStr = Bytes.bytes2string(bytes);
                action.log.info(String.format("[%d] Update = %s", action.id, ServletOps.formatForLog(requestStr)));
            }
            catch (Exception ex) {
                action.log.info(String.format("[%d] Update = <failed to decode>", action.id));
            }
        } else {
            action.log.info(String.format("[%d] Update", action.id));
        }
        this.execute(action, input);
        ServletOps.successNoContent(action);
    }

    private void executeForm(HttpAction action) {
        String requestStr = action.getRequestParameter("update");
        if (requestStr == null) {
            requestStr = action.getRequestParameter("request");
        }
        if (action.verbose) {
            action.log.info(String.format("[%d] Form update = \n%s", action.id, requestStr));
        }
        byte[] b = StrUtils.asUTF8bytes(requestStr);
        ByteArrayInputStream input = new ByteArrayInputStream(b);
        requestStr = null;
        this.execute(action, input);
        ServletOps.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(HttpAction action, InputStream input) {
        UsingList usingList = this.processProtocol(action.getRequest());
        UpdateRequest req = null;
        if (!action.isTransactional()) {
            try {
                req = UpdateFactory.read(usingList, input, UpdateParseBase, Syntax.syntaxARQ);
            }
            catch (UpdateException ex) {
                ServletOps.errorBadRequest(ex.getMessage());
                return;
            }
            catch (QueryParseException ex) {
                ServletOps.errorBadRequest(SPARQLProtocol.messageForException(ex));
                return;
            }
        }
        action.beginWrite();
        try {
            if (req == null) {
                UpdateAction.parseExecute(usingList, action.getActiveDSG(), input, UpdateParseBase, Syntax.syntaxARQ);
            } else {
                UpdateAction.execute(req, action.getActiveDSG());
            }
            action.commit();
        }
        catch (UpdateException ex) {
            ActionLib.consumeBody(action);
            SPARQL_Update.abortSilent(action);
            ActionExecLib.incCounter(action.getEndpoint().getCounters(), CounterName.UpdateExecErrors);
            ServletOps.errorOccurred(ex.getMessage());
        }
        catch (QueryParseException ex) {
            ActionLib.consumeBody(action);
            SPARQL_Update.abortSilent(action);
            String msg = SPARQLProtocol.messageForParseException(ex);
            action.log.warn(String.format("[%d] Parse error: %s", action.id, msg));
            ServletOps.errorBadRequest(SPARQLProtocol.messageForException(ex));
        }
        catch (QueryBuildException | QueryExceptionHTTP ex) {
            ActionLib.consumeBody(action);
            SPARQL_Update.abortSilent(action);
            String msg = SPARQLProtocol.messageForException(ex);
            action.log.warn(String.format("[%d] Bad request: %s", action.id, msg));
            ServletOps.errorBadRequest(SPARQLProtocol.messageForException(ex));
        }
        catch (OperationDeniedException ex) {
            ActionLib.consumeBody(action);
            SPARQL_Update.abortSilent(action);
            throw ex;
        }
        catch (Throwable ex) {
            ActionLib.consumeBody(action);
            if (!(ex instanceof ActionErrorException)) {
                SPARQL_Update.abortSilent(action);
                ServletOps.errorOccurred(ex.getMessage(), ex);
            }
        }
        finally {
            action.endWrite();
        }
    }

    private static ContentType updateContentType(HttpAction action) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct != null) {
            return ct;
        }
        if (action.getRequestParameter("update") != null || action.getRequestParameter("request") != null) {
            return WebContent.ctHTMLForm;
        }
        return WebContent.ctSPARQLUpdate;
    }

    private UsingList processProtocol(HttpServletRequest request) {
        UsingList toReturn = new UsingList();
        String[] usingArgs = request.getParameterValues("using-graph-uri");
        String[] usingNamedArgs = request.getParameterValues("using-named-graph-uri");
        if (usingArgs == null && usingNamedArgs == null) {
            return toReturn;
        }
        if (usingArgs == null) {
            usingArgs = new String[]{};
        }
        if (usingNamedArgs == null) {
            usingNamedArgs = new String[]{};
        }
        for (String nodeUri : usingArgs) {
            toReturn.addUsing(SPARQL_Update.createNode(nodeUri));
        }
        for (String nodeUri : usingNamedArgs) {
            toReturn.addUsingNamed(SPARQL_Update.createNode(nodeUri));
        }
        return toReturn;
    }

    private static void abortSilent(HttpAction action) {
        action.abortSilent();
    }

    private static Node createNode(String x) {
        try {
            IRIx iri2 = resolver.resolve(x);
            return NodeFactory.createURI(iri2.str());
        }
        catch (Exception ex) {
            ServletOps.errorBadRequest("SPARQL Update: bad IRI: " + x);
            return null;
        }
    }
}

