/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets.prefixes;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jena.irix.IRIx;

public class PrefixUtils {
    public static final String PREFIX = "prefix";
    public static final String URI = "uri";
    public static final Set<String> PARAMS = Set.of("prefix", "uri");
    private static final Pattern regex = Pattern.compile("\\p{Alpha}([\\w.-]*\\w)?");

    private PrefixUtils() {
    }

    public static boolean isPrefixesParam(String param) {
        return PARAMS.contains(param);
    }

    public static boolean prefixIsValid(String prefix) {
        if (prefix.isEmpty()) {
            return true;
        }
        return regex.matcher(prefix).matches();
    }

    public static boolean uriIsValid(String uri) {
        try {
            IRIx iri2 = IRIx.create(uri);
            return iri2.isReference();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

