/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryValidatorHTML {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramQuery = "query";
    static final String paramSyntax = "languageSyntax";

    private QueryValidatorHTML() {
    }

    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Syntax language;
            String[] args = httpRequest.getParameterValues(paramQuery);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No query parameter to validator");
                return;
            }
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many query parameters");
                return;
            }
            String queryString = httpRequest.getParameter(paramQuery).replaceAll("(\r|\n| )*$", "");
            String querySyntax = httpRequest.getParameter(paramSyntax);
            if (querySyntax == null || querySyntax.equals("")) {
                querySyntax = "SPARQL";
            }
            if ((language = Syntax.lookup(querySyntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + querySyntax);
                return;
            }
            String lineNumbersArg = httpRequest.getParameter(paramLineNumbers);
            String[] a = httpRequest.getParameterValues(paramFormat);
            boolean outputSPARQL = false;
            boolean outputPrefix = false;
            boolean outputAlgebra = false;
            boolean outputQuads = false;
            boolean outputOptimized = false;
            boolean outputOptimizedQuads = false;
            if (a != null) {
                for (String anA : a) {
                    if (anA.equals("sparql")) {
                        outputSPARQL = true;
                    }
                    if (anA.equals("prefix")) {
                        outputPrefix = true;
                    }
                    if (anA.equals("algebra")) {
                        outputAlgebra = true;
                    }
                    if (anA.equals("quads")) {
                        outputQuads = true;
                    }
                    if (anA.equals("opt")) {
                        outputOptimized = true;
                    }
                    if (!anA.equals("optquads")) continue;
                    outputOptimizedQuads = true;
                }
            }
            boolean lineNumbers = true;
            if (lineNumbersArg != null) {
                lineNumbers = lineNumbersArg.equalsIgnoreCase("true") || lineNumbersArg.equalsIgnoreCase("yes");
            }
            ValidatorHtmlLib.setHeaders(httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "SPARQL Query Validation Report");
            outStream.println("<body>");
            outStream.println("<h1>SPARQL Query Validator</h1>");
            outStream.println("<p>Input:</p>");
            ValidatorHtmlLib.output(outStream, out -> out.print(queryString), lineNumbers);
            Query query2 = null;
            try {
                query2 = QueryFactory.create(queryString, "http://example/base/", language);
            }
            catch (ARQException ex) {
                outStream.println("<p>Syntax error:</p>");
                ValidatorHtmlLib.startFixed(outStream);
                outStream.println(ex.getMessage());
                ValidatorHtmlLib.finishFixed(outStream);
            }
            catch (RuntimeException ex) {
                outStream.println("<p>Internal error:</p>");
                ValidatorHtmlLib.startFixed(outStream);
                outStream.println(ex.getMessage());
                ValidatorHtmlLib.finishFixed(outStream);
            }
            if (query2 != null) {
                if (outputSPARQL) {
                    QueryValidatorHTML.outputSyntax(outStream, query2, lineNumbers);
                }
                if (outputAlgebra) {
                    QueryValidatorHTML.outputAlgebra(outStream, query2, lineNumbers);
                }
                if (outputQuads) {
                    QueryValidatorHTML.outputAlgebraQuads(outStream, query2, lineNumbers);
                }
                if (outputOptimized) {
                    QueryValidatorHTML.outputAlgebraOpt(outStream, query2, lineNumbers);
                }
                if (outputOptimizedQuads) {
                    QueryValidatorHTML.outputAlgebraOptQuads(outStream, query2, lineNumbers);
                }
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            ValidatorHtmlLib.serviceLog.warn("Exception in doGet", ex);
        }
    }

    private static void outputSyntax(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        ValidatorHtmlLib.output(outStream, out -> query2.serialize((IndentedWriter)out), lineNumbers);
    }

    private static void outputAlgebra(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Algebra structure:</p>");
        Op op = Algebra.compile(query2);
        QueryValidatorHTML.outputQueryOp(outStream, query2, op, lineNumbers);
    }

    private static void outputAlgebraOpt(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Algebra, with general triple optimizations:</p>");
        Op op = Algebra.optimize(Algebra.compile(query2));
        QueryValidatorHTML.outputQueryOp(outStream, query2, op, lineNumbers);
    }

    private static void outputAlgebraQuads(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Quad structure:</p>");
        Op op = Algebra.toQuadForm(Algebra.compile(query2));
        QueryValidatorHTML.outputQueryOp(outStream, query2, op, lineNumbers);
    }

    private static void outputAlgebraOptQuads(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Algebra, with general quads optimizations:</p>");
        Op op = Algebra.optimize(Algebra.toQuadForm(Algebra.compile(query2)));
        QueryValidatorHTML.outputQueryOp(outStream, query2, op, lineNumbers);
    }

    private static void outputQueryOp(ServletOutputStream outStream, Query query2, Op op, boolean lineNumbers) throws IOException {
        SerializationContext sCxt = new SerializationContext(query2);
        ValidatorHtmlLib.output(outStream, out -> op.output((IndentedWriter)out, sCxt), lineNumbers);
    }
}

