/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.datatype;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.parsers.wkt.WKTReader;
import org.apache.jena.geosparql.implementation.parsers.wkt.WKTWriter;
import org.locationtech.jts.geom.Geometry;

public class WKTDatatype
extends GeometryDatatype {
    public static final String URI = "http://www.opengis.net/ont/geosparql#wktLiteral";
    public static final WKTDatatype INSTANCE = new WKTDatatype();

    private WKTDatatype() {
        super(URI);
    }

    @Override
    public String unparse(Object geometry) {
        if (geometry instanceof GeometryWrapper) {
            GeometryWrapper geometryWrapper = (GeometryWrapper)geometry;
            return WKTWriter.write(geometryWrapper);
        }
        throw new DatatypeFormatException("Object to unparse WKTDatatype is not a GeometryWrapper: " + String.valueOf(geometry));
    }

    @Override
    public GeometryWrapper read(String geometryLiteral) {
        WKTReader wktReader = WKTReader.extract(geometryLiteral);
        Geometry geometry = wktReader.getGeometry();
        String srsURI = wktReader.getSrsURI();
        DimensionInfo dimensionInfo = wktReader.getDimensionInfo();
        return new GeometryWrapper(geometry, srsURI, URI, dimensionInfo, geometryLiteral);
    }

    @Override
    public String toString() {
        return "WKTDatatype{http://www.opengis.net/ont/geosparql#wktLiteral}";
    }
}

