/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;

public class E_LogicalAnd
extends ExprFunction2 {
    private static final String functionName = "and";
    private static final String symbol = "&&";

    public E_LogicalAnd(Expr left, Expr right) {
        super(left, right, functionName, symbol);
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.getArg1().eval(binding, env);
            if (!XSDFuncOp.effectiveBooleanValue(x)) {
                return NodeValue.FALSE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.getArg2().eval(binding, env);
            if (!XSDFuncOp.effectiveBooleanValue(y)) {
                return NodeValue.FALSE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.TRUE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }

    @Override
    public NodeValue eval(NodeValue x, NodeValue y) {
        if (!x.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + String.valueOf(x));
        }
        if (!y.isBoolean()) {
            throw new ExprEvalException("Not a boolean: " + String.valueOf(y));
        }
        boolean boolX = x.getBoolean();
        boolean boolY = y.getBoolean();
        return NodeValue.makeBoolean(boolX && boolY);
    }

    @Override
    public Expr copy(Expr e1, Expr e2) {
        return new E_LogicalAnd(e1, e2);
    }
}

