/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.net.InetAddress;
import java.util.Arrays;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class InetAddressRange
extends Field {
    public static final int BYTES = 16;
    private static final FieldType TYPE = new FieldType();

    public InetAddressRange(String name, InetAddress min2, InetAddress max2) {
        super(name, TYPE);
        this.setRangeValues(min2, max2);
    }

    public void setRangeValues(InetAddress min2, InetAddress max2) {
        byte[] bytes;
        if (this.fieldsData == null) {
            bytes = new byte[32];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        InetAddressRange.encode(min2, max2, bytes);
    }

    private static void encode(InetAddress min2, InetAddress max2, byte[] bytes) {
        byte[] maxEncoded;
        byte[] minEncoded = InetAddressPoint.encode(min2);
        if (Arrays.compareUnsigned(minEncoded, 0, 16, maxEncoded = InetAddressPoint.encode(max2), 0, 16) > 0) {
            throw new IllegalArgumentException("min value cannot be greater than max value for InetAddressRange field");
        }
        System.arraycopy(minEncoded, 0, bytes, 0, 16);
        System.arraycopy(maxEncoded, 0, bytes, 16, 16);
    }

    private static byte[] encode(InetAddress min2, InetAddress max2) {
        byte[] b = new byte[32];
        InetAddressRange.encode(min2, max2, b);
        return b;
    }

    public static Query newIntersectsQuery(String field, InetAddress min2, InetAddress max2) {
        return InetAddressRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, InetAddress min2, InetAddress max2) {
        return InetAddressRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, InetAddress min2, InetAddress max2) {
        return InetAddressRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, InetAddress min2, InetAddress max2) {
        return InetAddressRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, InetAddress min2, InetAddress max2, RangeFieldQuery.QueryType relation) {
        return new RangeFieldQuery(field, InetAddressRange.encode(min2, max2), 1, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return InetAddressRange.toString(ranges, dimension);
            }
        };
    }

    private static String toString(byte[] ranges, int dimension) {
        byte[] min2 = new byte[16];
        System.arraycopy(ranges, 0, min2, 0, 16);
        byte[] max2 = new byte[16];
        System.arraycopy(ranges, 16, max2, 0, 16);
        return "[" + InetAddressPoint.decode(min2) + " : " + InetAddressPoint.decode(max2) + "]";
    }

    static {
        TYPE.setDimensions(2, 16);
        TYPE.freeze();
    }
}

