/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.document;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.sandbox.search.MultiRangeQuery;

public class DoublePointMultiRangeBuilder
extends MultiRangeQuery.Builder {
    public DoublePointMultiRangeBuilder(String field, int numDims) {
        super(field, 8, numDims);
    }

    @Override
    public MultiRangeQuery build() {
        return new MultiRangeQuery(this.field, this.numDims, this.bytesPerDim, this.clauses){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Double.toString(DoublePoint.decodeDimension(value, 0));
            }
        };
    }

    public void add(double[] lowerValue, double[] upperValue) {
        if (upperValue.length != this.numDims || lowerValue.length != this.numDims) {
            throw new IllegalArgumentException("Passed in range does not conform to specified dimensions");
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (!(upperValue[i] < lowerValue[i])) continue;
            throw new IllegalArgumentException("Upper value of range should be greater than lower value of range");
        }
        this.add(DoublePoint.pack((double[])lowerValue).bytes, DoublePoint.pack((double[])upperValue).bytes);
    }
}

