/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.IncludeControllerSchema;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.schema.BaseTestElementSchema;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeController
extends GenericController
implements ReplaceableController {
    private static final Logger log = LoggerFactory.getLogger(IncludeController.class);
    private static final long serialVersionUID = 241L;
    private static final String PREFIX = JMeterUtils.getPropDefault((String)"includecontroller.prefix", (String)"");
    private HashTree subtree = null;
    private TestElement sub = null;

    public IncludeControllerSchema getSchema() {
        return IncludeControllerSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends IncludeController, ? extends IncludeControllerSchema> getProps() {
        return new PropertiesAccessor((TestElement)this, (BaseTestElementSchema)this.getSchema());
    }

    public Object clone() {
        this.resolveReplacementSubTree(null);
        IncludeController clone = (IncludeController)((Object)super.clone());
        clone.setIncludePath(this.getIncludePath());
        if (this.subtree != null) {
            if (this.subtree.size() == 1) {
                for (Object o : this.subtree.keySet()) {
                    this.sub = (TestElement)o;
                }
            }
            clone.subtree = (HashTree)this.subtree.clone();
            clone.sub = this.sub == null ? null : (TestElement)this.sub.clone();
        }
        return clone;
    }

    public void setIncludePath(String jmxfile) {
        this.set((PropertyDescriptor)this.getSchema().getIncludePath(), jmxfile);
    }

    public String getIncludePath() {
        return this.get(this.getSchema().getIncludePath());
    }

    public HashTree getReplacementSubTree() {
        return this.subtree;
    }

    public TestElement getReplacementElement() {
        return this.sub;
    }

    public void resolveReplacementSubTree(JMeterTreeNode context) {
        this.subtree = this.loadIncludedElements();
    }

    protected HashTree loadIncludedElements() {
        String includePath = this.getIncludePath();
        HashTree tree = null;
        if (includePath != null && includePath.length() > 0) {
            String fileName = PREFIX + includePath;
            try {
                File file = new File(fileName.trim());
                String absolutePath = file.getAbsolutePath();
                log.info("loadIncludedElements -- try to load included module: {}", (Object)absolutePath);
                if (!file.exists() && !file.isAbsolute()) {
                    log.info("loadIncludedElements -failed for: {}", (Object)absolutePath);
                    file = new File(FileServer.getFileServer().getBaseDir(), includePath);
                    if (log.isInfoEnabled()) {
                        log.info("loadIncludedElements -Attempting to read it from: {}", (Object)file.getAbsolutePath());
                    }
                    if (!file.canRead() || !file.isFile()) {
                        log.error("Include Controller '{}' can't load '{}' - see log for details", (Object)this.getName(), (Object)fileName);
                        throw new IOException("loadIncludedElements -failed for: " + absolutePath + " and " + file.getAbsolutePath());
                    }
                }
                tree = SaveService.loadTree((File)file);
                tree = IncludeController.getProperBranch(tree);
                IncludeController.removeDisabledItems(tree);
                return tree;
            }
            catch (NoClassDefFoundError ex) {
                String msg = "Including file \"" + fileName + "\" failed for Include Controller \"" + this.getName() + "\", missing jar file";
                log.warn(msg, (Throwable)ex);
                JMeterUtils.reportErrorToUser((String)(msg + " - see log for details"));
            }
            catch (FileNotFoundException ex) {
                String msg = "File \"" + fileName + "\" not found for Include Controller \"" + this.getName() + "\"";
                JMeterUtils.reportErrorToUser((String)(msg + " - see log for details"));
                log.warn(msg, (Throwable)ex);
            }
            catch (Exception ex) {
                String msg = "Including file \"" + fileName + "\" failed for Include Controller \"" + this.getName() + "\", unexpected error";
                JMeterUtils.reportErrorToUser((String)(msg + " - see log for details"));
                log.warn(msg, (Throwable)ex);
            }
        }
        return tree;
    }

    private static HashTree getProperBranch(HashTree tree) {
        for (Object o : new ArrayList(tree.list())) {
            TestElement item = (TestElement)o;
            if (item instanceof TestPlan) {
                return IncludeController.getProperBranch(tree.getTree((Object)item));
            }
            if (!(item instanceof TestFragmentController)) continue;
            return tree.getTree((Object)item);
        }
        log.warn("No Test Fragment was found in included Test Plan, returning empty HashTree");
        return new HashTree();
    }

    private static void removeDisabledItems(HashTree tree) {
        for (Object o : new ArrayList(tree.list())) {
            TestElement item = (TestElement)o;
            if (!item.isEnabled()) {
                tree.remove((Object)item);
                continue;
            }
            IncludeController.removeDisabledItems(tree.getTree((Object)item));
        }
    }
}

