/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.FormUtil;
import org.apache.wiki.util.TextUtil;

public class FormOutput
extends FormElement {
    public String execute(Context ctx, Map<String, String> params) throws PluginException {
        if (ctx.getHttpRequest() == null) {
            return "";
        }
        ResourceBundle rb = Preferences.getBundle(ctx, "plugin.PluginResources");
        String formName = TextUtil.replaceEntities((String)params.get("form"));
        String submitForm = ctx.getHttpParameter("formname");
        String populator = params.get("populate");
        if (!(formName != null && formName.equals(submitForm) || "handler".equals(populator))) {
            return "";
        }
        String handler = TextUtil.replaceEntities((String)params.get("handler"));
        if (handler == null || handler.isEmpty()) {
            return "<p class=\"error\">" + MessageFormat.format(rb.getString("formoutput.missingargument"), "handler") + "</p>";
        }
        String sourcePage = ctx.getPage().getName();
        String submitServlet = ctx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), sourcePage);
        FormInfo info = this.getFormInfo(ctx);
        if (info == null) {
            info = new FormInfo();
            info.setName(formName);
        }
        info.setHandler(handler);
        info.setAction(submitServlet);
        Map handlerParams = FormUtil.requestToMap((HttpServletRequest)ctx.getHttpRequest(), (String)"nbf_");
        info.addSubmission(handlerParams);
        info.getSubmission().put("_body", params.get("_body"));
        String handlerOutput = null;
        String error = null;
        try {
            PluginManager pm = (PluginManager)ctx.getEngine().getManager(PluginManager.class);
            handlerOutput = pm.execute(ctx, handler, info.getSubmission());
            info.setResult(handlerOutput);
            info.setStatus(1);
        }
        catch (PluginException pe) {
            error = "<p class=\"error\">" + pe.getMessage() + "</p>";
            info.setError(error);
            info.setStatus(-1);
        }
        this.storeFormInfo(ctx, info);
        if (error != null) {
            return error;
        }
        return handlerOutput != null ? handlerOutput : "";
    }
}

